/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema;

import java.sql.SQLException;
import java.util.Map;
import org.apache.shardingsphere.api.config.RuleConfiguration;
import org.apache.shardingsphere.api.config.encrypt.EncryptRuleConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.EncryptSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.MasterSlaveSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.TransparentSchema;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class LogicSchemaFactory {
    public static LogicSchema newInstance(String schemaName, Map<String, Map<String, YamlDataSourceParameter>> schemaDataSources, RuleConfiguration ruleConfiguration, boolean isUsingRegistry) throws SQLException {
        if (ruleConfiguration instanceof ShardingRuleConfiguration) {
            return new ShardingSchema(schemaName, schemaDataSources.get(schemaName), (ShardingRuleConfiguration)ruleConfiguration, isUsingRegistry);
        }
        if (ruleConfiguration instanceof MasterSlaveRuleConfiguration) {
            return new MasterSlaveSchema(schemaName, schemaDataSources.get(schemaName), (MasterSlaveRuleConfiguration)ruleConfiguration, isUsingRegistry);
        }
        if (ruleConfiguration instanceof EncryptRuleConfiguration) {
            return new EncryptSchema(schemaName, schemaDataSources.get(schemaName), (EncryptRuleConfiguration)ruleConfiguration);
        }
        return new TransparentSchema(schemaName, schemaDataSources.get(schemaName));
    }

    private LogicSchemaFactory() {
    }
}

