/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.response.update;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.response.ExecuteResponse;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.response.ExecuteUpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;

public final class UpdateResponse
implements BackendResponse {
    private final List<Integer> updateCounts = new LinkedList<Integer>();
    private final long lastInsertId;
    private long updateCount;

    public UpdateResponse() {
        this(Collections.emptyList());
    }

    public UpdateResponse(Collection<ExecuteResponse> responseUnits) {
        for (ExecuteResponse each : responseUnits) {
            this.updateCount = ((ExecuteUpdateResponse)each).getUpdateCount();
            this.updateCounts.add(((ExecuteUpdateResponse)each).getUpdateCount());
        }
        this.lastInsertId = this.getLastInsertId(responseUnits);
    }

    private long getLastInsertId(Collection<ExecuteResponse> responseUnits) {
        long result = 0L;
        for (ExecuteResponse each : responseUnits) {
            result = Math.max(result, ((ExecuteUpdateResponse)each).getLastInsertId());
        }
        return result;
    }

    public void mergeUpdateCount() {
        this.updateCount = 0L;
        for (int each : this.updateCounts) {
            this.updateCount += (long)each;
        }
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }
}

