/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.response.query;

import java.beans.ConstructorProperties;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.shardingsphere.core.metadata.column.ColumnMetaData;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.ShardingSchema;

public final class QueryHeader {
    private final String schema;
    private final String table;
    private String columnLabel;
    private String columnName;
    private final int columnLength;
    private final Integer columnType;
    private final int decimals;
    private final boolean signed;
    private final boolean primaryKey;
    private final boolean notNull;
    private final boolean autoIncrement;

    public QueryHeader(ResultSetMetaData resultSetMetaData, LogicSchema logicSchema, int columnIndex) throws SQLException {
        this.schema = logicSchema.getName();
        if (logicSchema instanceof ShardingSchema) {
            Collection tableNames = logicSchema.getShardingRule().getLogicTableNames(resultSetMetaData.getTableName(columnIndex));
            String string = this.table = tableNames.isEmpty() ? "" : (String)tableNames.iterator().next();
            this.primaryKey = logicSchema.getMetaData().getTables().containsTable(resultSetMetaData.getTableName(columnIndex)) ? ((ColumnMetaData)logicSchema.getMetaData().getTables().get(resultSetMetaData.getTableName(columnIndex)).getColumns().get(resultSetMetaData.getColumnName(columnIndex).toLowerCase())).isPrimaryKey() : false;
        } else {
            this.table = resultSetMetaData.getTableName(columnIndex);
            this.primaryKey = false;
        }
        this.columnLabel = resultSetMetaData.getColumnLabel(columnIndex);
        this.columnName = resultSetMetaData.getColumnName(columnIndex);
        this.columnLength = resultSetMetaData.getColumnDisplaySize(columnIndex);
        this.columnType = resultSetMetaData.getColumnType(columnIndex);
        this.decimals = resultSetMetaData.getScale(columnIndex);
        this.signed = resultSetMetaData.isSigned(columnIndex);
        this.notNull = resultSetMetaData.isNullable(columnIndex) == 0;
        this.autoIncrement = resultSetMetaData.isAutoIncrement(columnIndex);
    }

    public void setColumnLabelAndName(String logicColumnName) {
        if (this.columnLabel.equals(this.columnName)) {
            this.columnLabel = logicColumnName;
            this.columnName = logicColumnName;
        } else {
            this.columnName = logicColumnName;
        }
    }

    @ConstructorProperties(value={"schema", "table", "columnLabel", "columnName", "columnLength", "columnType", "decimals", "signed", "primaryKey", "notNull", "autoIncrement"})
    public QueryHeader(String schema, String table, String columnLabel, String columnName, int columnLength, Integer columnType, int decimals, boolean signed, boolean primaryKey, boolean notNull, boolean autoIncrement) {
        this.schema = schema;
        this.table = table;
        this.columnLabel = columnLabel;
        this.columnName = columnName;
        this.columnLength = columnLength;
        this.columnType = columnType;
        this.decimals = decimals;
        this.signed = signed;
        this.primaryKey = primaryKey;
        this.notNull = notNull;
        this.autoIncrement = autoIncrement;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnLength() {
        return this.columnLength;
    }

    public Integer getColumnType() {
        return this.columnType;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }
}

