/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.List;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.merge.dql.EncryptorMetaData;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.spi.encrypt.ShardingEncryptor;

public final class QueryHeaderEncryptorMetaData
implements EncryptorMetaData {
    private final EncryptRule encryptRule;
    private final List<QueryHeader> queryHeaders;

    public Optional<ShardingEncryptor> findEncryptor(int columnIndex) {
        String columnName;
        QueryHeader queryHeader = this.queryHeaders.get(columnIndex - 1);
        String tableName = queryHeader.getTable();
        return this.encryptRule.isCipherColumn(tableName, columnName = queryHeader.getColumnName()) ? this.encryptRule.findShardingEncryptor(tableName, this.encryptRule.getLogicColumnOfCipher(tableName, columnName)) : Optional.absent();
    }

    @ConstructorProperties(value={"encryptRule", "queryHeaders"})
    public QueryHeaderEncryptorMetaData(EncryptRule encryptRule, List<QueryHeader> queryHeaders) {
        this.encryptRule = encryptRule;
        this.queryHeaders = queryHeaders;
    }
}

