/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.config.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.shardingsphere.orchestration.config.api.ConfigCenter;
import org.apache.shardingsphere.orchestration.config.api.ConfigCenterConfiguration;
import org.apache.shardingsphere.orchestration.config.listener.DataChangedEvent;
import org.apache.shardingsphere.orchestration.config.listener.DataChangedEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApolloConfigCenter
implements ConfigCenter {
    private static final Logger log = LoggerFactory.getLogger(ApolloConfigCenter.class);
    private Config apolloConfig;
    private Properties properties = new Properties();

    public void init(ConfigCenterConfiguration config) {
        System.getProperties().setProperty("app.id", this.properties.getProperty("appId", "APOLLO_SHARDING_SPHERE"));
        System.getProperties().setProperty("env", this.properties.getProperty("env", "DEV"));
        System.getProperties().setProperty("apollo.cluster", this.properties.getProperty("clusterName", "default"));
        System.getProperties().setProperty("apollo.meta", config.getServerLists());
        this.apolloConfig = ConfigService.getConfig((String)config.getNamespace());
    }

    public String get(String key) {
        return this.apolloConfig.getProperty(key.replace("/", "."), "");
    }

    public String getDirectly(String key) {
        return this.get(key);
    }

    public boolean isExisted(String key) {
        return !Strings.isNullOrEmpty((String)this.get(key));
    }

    public List<String> getChildrenKeys(String key) {
        throw new UnsupportedOperationException();
    }

    public void persist(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public void update(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public void persistEphemeral(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public void watch(String key, final DataChangedEventListener dataChangedEventListener) {
        this.apolloConfig.addChangeListener(new ConfigChangeListener(){

            public void onChange(ConfigChangeEvent changeEvent) {
                for (String key : changeEvent.changedKeys()) {
                    ConfigChange change = changeEvent.getChange(key);
                    DataChangedEvent.ChangedType changedType = ApolloConfigCenter.this.getChangedType(change.getChangeType());
                    if (DataChangedEvent.ChangedType.IGNORED == changedType) continue;
                    dataChangedEventListener.onChange(new DataChangedEvent(key, change.getNewValue(), changedType));
                }
            }
        }, (Set)Sets.newHashSet((Object[])new String[]{key}));
    }

    private DataChangedEvent.ChangedType getChangedType(PropertyChangeType changeType) {
        switch (changeType) {
            case MODIFIED: {
                return DataChangedEvent.ChangedType.UPDATED;
            }
            case DELETED: {
                return DataChangedEvent.ChangedType.DELETED;
            }
        }
        return DataChangedEvent.ChangedType.IGNORED;
    }

    public void close() {
    }

    public String getType() {
        return "apollo";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

