/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.war.deployer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, 4096);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > 262144) {
            avail = 262144;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        return total;
    }

    public static int copyAndClose(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copyAndClose(input, output, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyAndClose(InputStream input, OutputStream output, int bufferSize) throws IOException {
        try {
            int n = IOUtils.copy(input, output, bufferSize);
            return n;
        }
        finally {
            try {
                input.close();
            }
            finally {
                output.close();
            }
        }
    }
}

