/*
 * Decompiled with CFR 0.152.
 */
package krati.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import krati.store.ArrayStorePartition;
import krati.util.PartitionLoader;
import org.apache.log4j.Logger;

public class SimplePartitionLoader
implements PartitionLoader {
    private static final Logger _log = Logger.getLogger(SimplePartitionLoader.class);

    @Override
    public void load(ArrayStorePartition partition, File dataFile) throws IOException {
        String line;
        int index;
        FileReader reader = new FileReader(dataFile);
        BufferedReader in = new BufferedReader(reader);
        int stopIndex = index + partition.getIdCount();
        for (index = partition.getIdStart(); (line = in.readLine()) != null && index < stopIndex; ++index) {
            try {
                partition.set(index, line.getBytes(), index);
                continue;
            }
            catch (Exception e) {
                _log.error((Object)("index=" + index + ": " + e.getMessage()));
                e.printStackTrace();
            }
        }
        in.close();
        reader.close();
        partition.persist();
    }

    @Override
    public void dump(ArrayStorePartition partition, File dumpFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(dumpFile);
        PrintWriter out = new PrintWriter(fos);
        int cnt = partition.getIdCount();
        for (int index = partition.getIdStart(); index < cnt; ++index) {
            byte[] data = partition.get(index);
            if (data != null) {
                String line = new String(data);
                out.println(line);
            } else {
                out.println();
            }
            if (index % 10000 != 0) continue;
            out.flush();
        }
        out.flush();
        out.close();
        fos.close();
    }
}

