/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import krati.array.DataArray;
import krati.core.StoreConfig;
import krati.core.array.AddressArray;
import krati.core.array.AddressArrayFactory;
import krati.core.array.SimpleDataArray;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;
import krati.store.DataStore;
import krati.store.DataStoreHandler;
import krati.store.DataStoreIterator;
import krati.store.DataStoreKeyIterator;
import krati.store.DefaultDataStoreHandler;
import krati.store.StoreClosedException;
import krati.util.FnvHashFunction;
import krati.util.HashFunction;
import org.apache.log4j.Logger;

public class StaticDataStore
implements DataStore<byte[], byte[]> {
    private static final Logger _log = Logger.getLogger(StaticDataStore.class);
    private final File _homeDir;
    private final StoreConfig _config;
    private final SimpleDataArray _dataArray;
    private final DataStoreHandler _dataHandler;
    private final HashFunction<byte[]> _hashFunction;

    public StaticDataStore(StoreConfig config) throws Exception {
        config.validate();
        config.save();
        this._config = config;
        this._homeDir = this._config.getHomeDir();
        this._dataHandler = new DefaultDataStoreHandler();
        AddressArray addressArray = this.createAddressArray(this._config.getHomeDir(), this._config.getInitialCapacity(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.getIndexesCached());
        if (addressArray.length() != this._config.getInitialCapacity()) {
            addressArray.close();
            throw new IOException("Capacity expected: " + addressArray.length() + " not " + this._config.getInitialCapacity());
        }
        String segmentHome = this._homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(addressArray, segmentManager, this._config.getSegmentCompactFactor());
        this._hashFunction = this._config.getHashFunction();
    }

    public StaticDataStore(File homeDir, int capacity, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, 10000, 5, 256, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataStore(File homeDir, int capacity, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, 10000, 5, 256, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataStore(File homeDir, int capacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, capacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, 0.5, new FnvHashFunction());
    }

    public StaticDataStore(File homeDir, int capacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, capacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, 0.5, hashFunction);
    }

    public StaticDataStore(File homeDir, int capacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor, HashFunction<byte[]> hashFunction) throws Exception {
        this._homeDir = homeDir;
        this._config = new StoreConfig(this._homeDir, capacity);
        this._config.setBatchSize(batchSize);
        this._config.setNumSyncBatches(numSyncBatches);
        this._config.setSegmentFactory(segmentFactory);
        this._config.setSegmentFileSizeMB(segmentFileSizeMB);
        this._config.setSegmentCompactFactor(segmentCompactFactor);
        this._config.setHashFunction(hashFunction);
        this._config.validate();
        this._config.save();
        this._dataHandler = new DefaultDataStoreHandler();
        AddressArray addressArray = this.createAddressArray(this._config.getHomeDir(), this._config.getInitialCapacity(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.getIndexesCached());
        if (addressArray.length() != capacity) {
            addressArray.close();
            throw new IOException("Capacity expected: " + addressArray.length() + " not " + capacity);
        }
        String segmentHome = this._homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(addressArray, segmentManager, this._config.getSegmentCompactFactor());
        this._hashFunction = this._config.getHashFunction();
    }

    protected AddressArray createAddressArray(File homeDir, int length, int batchSize, int numSyncBatches, boolean indexesCached) throws Exception {
        AddressArrayFactory factory = new AddressArrayFactory(indexesCached);
        AddressArray addrArray = factory.createStaticAddressArray(homeDir, length, batchSize, numSyncBatches);
        return addrArray;
    }

    protected long hash(byte[] key) {
        return this._hashFunction.hash(key);
    }

    protected long nextScn() {
        return System.currentTimeMillis();
    }

    @Override
    public byte[] get(byte[] key) {
        byte[] existingData;
        long hashCode = this.hash(key);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        return (existingData = this._dataArray.get(index)) == null ? null : this._dataHandler.extractByKey(key, existingData);
    }

    @Override
    public synchronized boolean put(byte[] key, byte[] value) throws Exception {
        byte[] existingData;
        if (value == null) {
            return this.delete(key);
        }
        long hashCode = this.hash(key);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        if ((existingData = this._dataArray.get(index)) == null || existingData.length == 0) {
            this._dataArray.set(index, this._dataHandler.assemble(key, value), this.nextScn());
        } else {
            try {
                this._dataArray.set(index, this._dataHandler.assemble(key, value, existingData), this.nextScn());
            }
            catch (Exception e) {
                _log.warn((Object)("Value reset at index=" + index + " key=\"" + new String(key) + "\""));
                this._dataArray.set(index, this._dataHandler.assemble(key, value), this.nextScn());
            }
        }
        return true;
    }

    @Override
    public synchronized boolean delete(byte[] key) throws Exception {
        long hashCode = this.hash(key);
        int index = (int)(hashCode % (long)this._dataArray.length());
        if (index < 0) {
            index = -index;
        }
        try {
            byte[] existingData = this._dataArray.get(index);
            if (existingData != null) {
                int newLength = this._dataHandler.removeByKey(key, existingData);
                if (newLength == 0) {
                    this._dataArray.set(index, null, this.nextScn());
                    return true;
                }
                if (newLength < existingData.length) {
                    this._dataArray.set(index, existingData, 0, newLength, this.nextScn());
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.warn((Object)("Failed to delete key=\"" + new String(key) + "\" : " + e.getMessage()));
            this._dataArray.set(index, null, this.nextScn());
        }
        return false;
    }

    @Override
    public synchronized void sync() throws IOException {
        this._dataArray.sync();
    }

    @Override
    public synchronized void persist() throws IOException {
        this._dataArray.persist();
    }

    @Override
    public synchronized void clear() throws IOException {
        this._dataArray.clear();
    }

    @Override
    public final int capacity() {
        return this._dataArray.length();
    }

    public final File getHomeDir() {
        return this._homeDir;
    }

    public final DataArray getDataArray() {
        return this._dataArray;
    }

    @Override
    public Iterator<byte[]> keyIterator() {
        if (this.isOpen()) {
            return new DataStoreKeyIterator(this._dataArray, this._dataHandler);
        }
        throw new StoreClosedException();
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        if (this.isOpen()) {
            return new DataStoreIterator(this._dataArray, this._dataHandler);
        }
        throw new StoreClosedException();
    }

    @Override
    public boolean isOpen() {
        return this._dataArray.isOpen();
    }

    @Override
    public synchronized void open() throws IOException {
        if (!this._dataArray.isOpen()) {
            this._dataArray.open();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._dataArray.isOpen()) {
            this._dataArray.close();
        }
    }
}

