/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import krati.store.DataStoreHandler;
import org.apache.log4j.Logger;

public final class DefaultDataStoreHandler
implements DataStoreHandler {
    private static final Logger _log = Logger.getLogger(DefaultDataStoreHandler.class);
    private static final int NUM_BYTES_IN_INT = 4;

    @Override
    public final byte[] assemble(byte[] key, byte[] value) {
        if (value == null) {
            return null;
        }
        byte[] result = new byte[8 + key.length + 4 + value.length];
        ByteBuffer bb = ByteBuffer.wrap(result);
        bb.putInt(1);
        bb.putInt(key.length);
        bb.put(key);
        bb.putInt(value.length);
        bb.put(value);
        return result;
    }

    @Override
    public final byte[] assemble(byte[] key, byte[] value, byte[] data) {
        if (data == null || data.length == 0) {
            return this.assemble(key, value);
        }
        int newLength = this.removeByKey(key, data);
        if (newLength == 0) {
            return this.assemble(key, value);
        }
        if (value == null) {
            return Arrays.copyOf(data, newLength);
        }
        byte[] result = new byte[newLength + 4 + key.length + 4 + value.length];
        System.arraycopy(data, 0, result, 0, newLength);
        ByteBuffer bb = ByteBuffer.wrap(result);
        int cnt = bb.getInt();
        bb.position(0);
        bb.putInt(cnt + 1);
        bb.position(newLength);
        bb.putInt(key.length);
        bb.put(key);
        bb.putInt(value.length);
        bb.put(value);
        return result;
    }

    @Override
    public final int countCollisions(byte[] key, byte[] data) {
        if (data == null || data.length == 0) {
            return 0;
        }
        try {
            int originalCnt;
            ByteBuffer bb = ByteBuffer.wrap(data);
            for (int cnt = originalCnt = bb.getInt(); cnt > 0; --cnt) {
                int len = bb.getInt();
                if (DefaultDataStoreHandler.keysEqual(key, data, bb.position(), len)) {
                    return originalCnt;
                }
                bb.position(bb.position() + len);
                len = bb.getInt();
                bb.position(bb.position() + len);
            }
            return -originalCnt;
        }
        catch (Exception e) {
            _log.error((Object)"Failed to countCollisions", (Throwable)e);
            return 0;
        }
    }

    @Override
    public final byte[] extractByKey(byte[] key, byte[] data) {
        if (data.length == 0) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(data);
        for (int cnt = bb.getInt(); cnt > 0; --cnt) {
            int len = bb.getInt();
            if (DefaultDataStoreHandler.keysEqual(key, data, bb.position(), len)) {
                bb.position(bb.position() + len);
                len = bb.getInt();
                byte[] result = new byte[len];
                bb.get(result);
                return result;
            }
            bb.position(bb.position() + len);
            len = bb.getInt();
            bb.position(bb.position() + len);
        }
        return null;
    }

    @Override
    public final int removeByKey(byte[] key, byte[] data) {
        int originalCnt;
        int offset1 = 0;
        int offset2 = 0;
        ByteBuffer bb = ByteBuffer.wrap(data);
        for (int cnt = originalCnt = bb.getInt(); cnt > 0; --cnt) {
            offset1 = bb.position();
            int len = bb.getInt();
            if (DefaultDataStoreHandler.keysEqual(key, data, bb.position(), len)) {
                bb.position(bb.position() + len);
                len = bb.getInt();
                bb.position(bb.position() + len);
                offset2 = bb.position();
                break;
            }
            bb.position(bb.position() + len);
            len = bb.getInt();
            bb.position(bb.position() + len);
        }
        if (offset1 < offset2) {
            int newLength = data.length - (offset2 - offset1);
            if (newLength <= 4) {
                return 0;
            }
            bb.position(0);
            bb.putInt(originalCnt - 1);
            int len = data.length - offset2;
            for (int i = 0; i < len; ++i) {
                data[offset1 + i] = data[offset2 + i];
            }
            return newLength;
        }
        return data.length;
    }

    static boolean keysEqual(byte[] key, byte[] keySource, int offset, int length) {
        if (key.length == length) {
            for (int i = 0; i < length; ++i) {
                if (key[i] == keySource[offset + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final List<byte[]> extractKeys(byte[] data) {
        try {
            int cnt;
            ByteBuffer bb = ByteBuffer.wrap(data);
            ArrayList<byte[]> result = new ArrayList<byte[]>(cnt);
            for (cnt = bb.getInt(); cnt > 0; --cnt) {
                int len = bb.getInt();
                byte[] key = new byte[len];
                bb.get(key);
                result.add(key);
                len = bb.getInt();
                bb.position(bb.position() + len);
            }
            return result;
        }
        catch (Exception e) {
            _log.error((Object)"Failed to extractKeys", (Throwable)e);
            return null;
        }
    }

    public final List<byte[]> extractValues(byte[] data) {
        try {
            int cnt;
            ByteBuffer bb = ByteBuffer.wrap(data);
            ArrayList<byte[]> result = new ArrayList<byte[]>(cnt);
            for (cnt = bb.getInt(); cnt > 0; --cnt) {
                int len = bb.getInt();
                bb.position(bb.position() + len);
                len = bb.getInt();
                byte[] value = new byte[len];
                bb.get(value);
                result.add(value);
            }
            return result;
        }
        catch (Exception e) {
            _log.error((Object)"Failed to extractValues", (Throwable)e);
            return null;
        }
    }

    @Override
    public final List<Map.Entry<byte[], byte[]>> extractEntries(byte[] data) {
        try {
            int cnt;
            ByteBuffer bb = ByteBuffer.wrap(data);
            ArrayList<Map.Entry<byte[], byte[]>> result = new ArrayList<Map.Entry<byte[], byte[]>>(cnt);
            for (cnt = bb.getInt(); cnt > 0; --cnt) {
                int len = bb.getInt();
                byte[] key = new byte[len];
                bb.get(key);
                len = bb.getInt();
                byte[] val = new byte[len];
                bb.get(val);
                result.add(new AbstractMap.SimpleEntry<byte[], byte[]>(key, val));
            }
            return result;
        }
        catch (Exception e) {
            _log.error((Object)"Failed to extractEntries", (Throwable)e);
            return null;
        }
    }

    @Override
    public final byte[] assembleEntries(List<Map.Entry<byte[], byte[]>> entries) {
        byte[] b;
        int cnt = 0;
        int len = 4;
        for (Map.Entry<byte[], byte[]> e : entries) {
            b = e.getKey();
            if (b == null) continue;
            len += 4;
            len += b.length;
            b = e.getValue();
            len += 4;
            len += b == null ? 0 : e.getValue().length;
            ++cnt;
        }
        byte[] data = new byte[len];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.putInt(cnt);
        for (Map.Entry<byte[], byte[]> e : entries) {
            b = e.getKey();
            if (b == null) continue;
            bb.putInt(b.length);
            bb.put(b);
            b = e.getValue();
            if (b == null) {
                bb.putInt(0);
                continue;
            }
            bb.putInt(b.length);
            bb.put(b);
        }
        return data;
    }
}

