/*
 * Decompiled with CFR 0.152.
 */
package krati.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import krati.io.DataReader;

public class MultiMappedReader
implements DataReader {
    private final File _file;
    private long _currentPosition;
    private RandomAccessFile _raf;
    private MappedByteBuffer[] _mmapArray;
    public static final int BUFFER_BITS = 27;
    public static final int BUFFER_SIZE = 0x8000000;
    public static final long BUFFER_MASK = 0x7FFFFFFL;

    public MultiMappedReader(File file) {
        this._file = file;
        this._currentPosition = 0L;
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public void open() throws IOException {
        if (!this._file.exists()) {
            throw new IOException("Cannot find file " + this._file.getAbsolutePath());
        }
        if (this._file.isDirectory()) {
            throw new IOException("Cannot open directory " + this._file.getAbsolutePath());
        }
        this._raf = new RandomAccessFile(this._file, "r");
        int cnt = 0;
        long position = 0L;
        cnt = (int)(this._raf.length() >> 27);
        this._mmapArray = new MappedByteBuffer[cnt += (this._raf.length() & 0x7FFFFFFL) > 0L ? 1 : 0];
        for (int i = 0; i < cnt; ++i) {
            long size = Math.min(this._raf.length() - position, 0x8000000L);
            this._mmapArray[i] = this._raf.getChannel().map(FileChannel.MapMode.READ_ONLY, position, size);
            position += 0x8000000L;
        }
        this._currentPosition = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this._raf.close();
        }
        finally {
            this._raf = null;
            this._mmapArray = null;
            this._currentPosition = 0L;
        }
    }

    @Override
    public int readInt() throws IOException {
        int pos = (int)(this._currentPosition & 0x7FFFFFFL);
        int ind = (int)(this._currentPosition >> 27);
        int val = this._mmapArray[ind].getInt(pos);
        this._currentPosition += 4L;
        return val;
    }

    @Override
    public long readLong() throws IOException {
        int pos = (int)(this._currentPosition & 0x7FFFFFFL);
        int ind = (int)(this._currentPosition >> 27);
        long val = this._mmapArray[ind].getLong(pos);
        this._currentPosition += 8L;
        return val;
    }

    @Override
    public short readShort() throws IOException {
        int pos = (int)(this._currentPosition & 0x7FFFFFFL);
        int ind = (int)(this._currentPosition >> 27);
        short val = this._mmapArray[ind].getShort(pos);
        this._currentPosition += 2L;
        return val;
    }

    @Override
    public int readInt(long position) throws IOException {
        int pos = (int)(position & 0x7FFFFFFL);
        int ind = (int)(position >> 27);
        return this._mmapArray[ind].getInt(pos);
    }

    @Override
    public long readLong(long position) throws IOException {
        int pos = (int)(position & 0x7FFFFFFL);
        int ind = (int)(position >> 27);
        return this._mmapArray[ind].getLong(pos);
    }

    @Override
    public short readShort(long position) throws IOException {
        int pos = (int)(position & 0x7FFFFFFL);
        int ind = (int)(position >> 27);
        return this._mmapArray[ind].getShort(pos);
    }

    @Override
    public long position() throws IOException {
        return this._currentPosition;
    }

    @Override
    public void position(long newPosition) throws IOException {
        int i;
        int pos = (int)(newPosition & 0x7FFFFFFL);
        int ind = (int)(newPosition >> 27);
        for (i = 0; i < ind; ++i) {
            this._mmapArray[i].position(0x7FFFFFF);
        }
        this._mmapArray[ind].position(pos);
        for (i = ind; i < this._mmapArray.length; ++i) {
            this._mmapArray[i].clear();
        }
        this._currentPosition = newPosition;
    }
}

