/*
 * Decompiled with CFR 0.152.
 */
package krati.io;

import java.io.File;
import krati.io.ChannelReader;
import krati.io.ChannelWriter;
import krati.io.DataReader;
import krati.io.DataWriter;
import krati.io.IOType;
import krati.io.MappedReader;
import krati.io.MappedWriter;
import krati.io.MultiMappedReader;
import krati.io.MultiMappedWriter;

public class IOFactory {
    public static final DataReader createDataReader(File file, IOType type) {
        if (type == IOType.MAPPED) {
            if (file.length() <= Integer.MAX_VALUE) {
                return new MappedReader(file);
            }
            return new MultiMappedReader(file);
        }
        return new ChannelReader(file);
    }

    public static final DataWriter createDataWriter(File file, IOType type) {
        if (type == IOType.MAPPED) {
            if (file.length() <= Integer.MAX_VALUE) {
                return new MappedWriter(file);
            }
            return new MultiMappedWriter(file);
        }
        return new ChannelWriter(file);
    }
}

