/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Date;
import krati.core.segment.Segment;

public abstract class AbstractSegment
implements Segment {
    protected final int _segId;
    protected final File _segFile;
    protected final int _initSizeMB;
    protected final long _initSizeBytes;
    protected volatile long _lastForcedTime;
    protected volatile Segment.Mode _segMode;
    protected RandomAccessFile _raf = null;
    protected FileChannel _channel = null;
    protected long _storageVersion;
    private volatile int _incrLoadSize = 0;
    private volatile int _decrLoadSize = 0;

    protected AbstractSegment(int segmentId, File segmentFile, int initialSizeMB, Segment.Mode mode) throws IOException {
        this._segId = segmentId;
        this._segFile = segmentFile;
        this._initSizeMB = initialSizeMB;
        this._initSizeBytes = (long)initialSizeMB * 1024L * 1024L;
        this._segMode = mode;
        this.init();
    }

    protected abstract void init() throws IOException;

    protected void initHeader() throws IOException {
        this._incrLoadSize = 0;
        this._decrLoadSize = 0;
        this._lastForcedTime = System.currentTimeMillis();
        this._storageVersion = 1L;
        this.setAppendPosition(0L);
        this.appendLong(this.getLastForcedTime());
        this.decrLoadSize(8);
        this.appendLong(this.getStorageVersion());
        this.decrLoadSize(8);
        this.force();
        this._channel.position(128L);
        this.setAppendPosition(128L);
    }

    protected void loadHeader() throws IOException {
        this._lastForcedTime = this.readLong(0);
        this._storageVersion = this.readLong(8);
    }

    protected String getHeader() {
        StringBuilder b = new StringBuilder();
        b.append("lastForcedTime");
        b.append('=');
        b.append(new Date(this.getLastForcedTime()));
        b.append(' ');
        b.append("storageVersion");
        b.append('=');
        b.append(this.getStorageVersion());
        return b.toString();
    }

    protected long getChannelPosition() throws IOException {
        return this._channel == null ? -1L : this._channel.position();
    }

    @Override
    public String getStatus() {
        StringBuilder b = new StringBuilder();
        b.append("loadSize");
        b.append('=');
        b.append(this.getLoadSize());
        b.append(' ');
        b.append("appendPosition");
        b.append('=');
        try {
            b.append(this.getAppendPosition());
        }
        catch (IOException ioe) {
            b.append('?');
        }
        b.append(' ');
        b.append("channelPosition");
        b.append('=');
        try {
            b.append(this.getChannelPosition());
        }
        catch (Exception e) {
            b.append('?');
        }
        b.append(' ');
        b.append("lastForcedTime");
        b.append('=');
        b.append(new Date(this.getLastForcedTime()));
        return b.toString();
    }

    @Override
    public final Segment.Mode getMode() {
        return this._segMode;
    }

    @Override
    public final int getSegmentId() {
        return this._segId;
    }

    @Override
    public final File getSegmentFile() {
        return this._segFile;
    }

    @Override
    public final int getInitialSizeMB() {
        return this._initSizeMB;
    }

    @Override
    public final long getInitialSize() {
        return this._initSizeBytes;
    }

    @Override
    public final long getLastForcedTime() {
        return this._lastForcedTime;
    }

    @Override
    public final long getStorageVersion() {
        return this._storageVersion;
    }

    @Override
    public final double getLoadFactor() {
        return (double)this.getLoadSize() / (double)this._initSizeBytes;
    }

    @Override
    public final int getLoadSize() {
        return this._incrLoadSize - this._decrLoadSize;
    }

    @Override
    public final void incrLoadSize(int byteCnt) {
        this._incrLoadSize += byteCnt;
    }

    @Override
    public final void decrLoadSize(int byteCnt) {
        this._decrLoadSize += byteCnt;
    }

    @Override
    public final boolean isReadOnly() {
        return this._segMode == Segment.Mode.READ_ONLY;
    }
}

