/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.entry;

import java.io.File;
import java.io.IOException;
import krati.io.ChannelWriter;
import org.apache.log4j.Logger;

public class EntryFileWriter {
    private static final Logger _log = Logger.getLogger(EntryFileWriter.class);
    private static final long STORAGE_VERESION_POSITION = 0L;
    private static final long HEAD_MIN_SCN_POSITION = 8L;
    private static final long HEAD_MAX_SCN_POSITION = 16L;
    private static final long ENTRY_VALUE_CNT_POSITION = 24L;
    private static final long DATA_START_POSITION = 28L;
    private final ChannelWriter _writer;
    private int _valCnt = 0;
    private long _minScn = 0L;
    private long _maxScn = 0L;

    public EntryFileWriter(File file) {
        this._writer = new ChannelWriter(file);
        this._valCnt = 0;
    }

    public File getFile() {
        return this._writer.getFile();
    }

    public long getMinScn() {
        return this._minScn;
    }

    public long getMaxScn() {
        return this._maxScn;
    }

    public void open(long minScn, long maxScn) throws IOException {
        this._writer.open();
        this._valCnt = 0;
        this._minScn = minScn;
        this._maxScn = maxScn;
        this._writer.writeLong(0L, 0L);
        this._writer.writeLong(8L, minScn);
        this._writer.writeLong(16L, maxScn);
        this._writer.writeInt(24L, this._valCnt);
        this._writer.position(28L);
        _log.info((Object)("opened: minScn=" + this._minScn + " maxScn=" + this._maxScn + " valCnt=" + this._valCnt + " file=" + this._writer.getFile().getName()));
    }

    public void close() throws IOException {
        this._writer.writeInt(24L, this._valCnt);
        this._writer.writeLong(this._minScn);
        this._writer.writeLong(this._maxScn);
        this._writer.close();
        _log.info((Object)("closed: minScn=" + this._minScn + " maxScn=" + this._maxScn + " valCnt=" + this._valCnt));
        this._valCnt = 0;
        this._minScn = 0L;
        this._maxScn = 0L;
    }

    public void flush() throws IOException {
        this._writer.flush();
    }

    public void write(int pos, int val, long scn) throws IOException {
        this._writer.writeInt(pos);
        this._writer.writeInt(val);
        this._writer.writeLong(scn);
        ++this._valCnt;
    }

    public void write(int pos, long val, long scn) throws IOException {
        this._writer.writeInt(pos);
        this._writer.writeLong(val);
        this._writer.writeLong(scn);
        ++this._valCnt;
    }

    public void write(int pos, short val, long scn) throws IOException {
        this._writer.writeInt(pos);
        this._writer.writeShort(val);
        this._writer.writeLong(scn);
        ++this._valCnt;
    }
}

