/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import krati.array.Array;
import krati.array.DynamicArray;
import krati.array.IntArray;
import krati.core.array.basic.AbstractRecoverableArray;
import krati.core.array.basic.ArrayExpandListener;
import krati.core.array.basic.MemoryIntArray;
import krati.core.array.entry.EntryIntFactory;
import krati.core.array.entry.EntryValueInt;
import org.apache.log4j.Logger;

public class DynamicIntArray
extends AbstractRecoverableArray<EntryValueInt>
implements IntArray,
DynamicArray,
ArrayExpandListener {
    private static final int _subArrayBits = 16;
    private static final int _subArraySize = 65536;
    private static final Logger _log = Logger.getLogger(DynamicIntArray.class);
    private MemoryIntArray _internalArray;

    public DynamicIntArray(int entrySize, int maxEntries, File directory) throws Exception {
        super(65536, 4, entrySize, maxEntries, directory, new EntryIntFactory());
    }

    @Override
    protected Logger getLogger() {
        return _log;
    }

    @Override
    protected void loadArrayFileData() throws IOException {
        long maxScn = this._arrayFile.getLwmScn();
        try {
            this._internalArray = new MemoryIntArray(16);
            this._arrayFile.load(this._internalArray);
            this.expandCapacity(this._internalArray.length() - 1);
            this._internalArray.setArrayExpandListener(this);
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException("Failed to load array file", e);
        }
        this._entryManager.setWaterMarks(maxScn, maxScn);
    }

    @Override
    public void saveHWMark(long endOfPeriod) {
        if (this.getHWMark() < endOfPeriod) {
            try {
                this.set(0, this.get(0), endOfPeriod);
            }
            catch (Exception e) {
                _log.error((Object)("Failed to saveHWMark " + endOfPeriod), (Throwable)e);
            }
        } else if (0L < endOfPeriod && endOfPeriod < this.getLWMark()) {
            try {
                this._entryManager.sync();
            }
            catch (Exception e) {
                _log.error((Object)("Failed to saveHWMark" + endOfPeriod), (Throwable)e);
            }
            this._entryManager.setWaterMarks(endOfPeriod, endOfPeriod);
        }
    }

    @Override
    public void clear() {
        if (this._internalArray != null) {
            this._internalArray.clear();
        }
        this._entryManager.clear();
        try {
            this._arrayFile.reset(this._internalArray, this._entryManager.getLWMark());
        }
        catch (IOException e) {
            _log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int get(int index) {
        return this._internalArray.get(index);
    }

    @Override
    public void set(int index, int value, long scn) throws Exception {
        this._internalArray.set(index, value);
        this._entryManager.addToPreFillEntryInt(index, value, scn);
    }

    @Override
    public int[] getInternalArray() {
        return this._internalArray.getInternalArray();
    }

    @Override
    public void expandCapacity(int index) throws Exception {
        int newLength;
        if (index < this._length) {
            return;
        }
        long capacity = ((long)(index >> 16) + 1L) * 65536L;
        int n = newLength = capacity < Integer.MAX_VALUE ? (int)capacity : Integer.MAX_VALUE;
        if (this._internalArray.length() < newLength) {
            this._internalArray.expandCapacity(index);
        }
        this._arrayFile.setArrayLength(newLength, null);
        this._length = newLength;
        _log.info((Object)("Expanded: _length=" + this._length));
    }

    @Override
    public void arrayExpanded(DynamicArray dynArray) {
        if (dynArray == this._internalArray) {
            try {
                this.expandCapacity(dynArray.length() - 1);
            }
            catch (Exception e) {
                _log.error((Object)("Failed to expand: length=" + dynArray.length()));
            }
        }
    }

    public final int subArrayLength() {
        return 65536;
    }

    @Override
    public final Array.Type getType() {
        return Array.Type.DYNAMIC;
    }
}

