/*
 * Decompiled with CFR 0.152.
 */
package krati.core;

import java.util.Properties;
import krati.util.LinearHashing;

public class StoreParams {
    protected final Properties _properties = new Properties();
    public static final boolean INDEXES_CACHED_DEFAULT = true;
    public static final int BATCH_SIZE_MIN = 1;
    public static final int BATCH_SIZE_DEFAULT = 10000;
    public static final int NUM_SYNC_BATCHES_MIN = 1;
    public static final int NUM_SYNC_BATCHES_DEFAULT = 5;
    public static final int SEGMENT_FILE_SIZE_MB_MIN = 8;
    public static final int SEGMENT_FILE_SIZE_MB_MAX = 2048;
    public static final int SEGMENT_FILE_SIZE_MB_DEFAULT = 256;
    public static final double SEGMENT_COMPACT_FACTOR_MIN = 0.0;
    public static final double SEGMENT_COMPACT_FACTOR_MAX = 0.75;
    public static final double SEGMENT_COMPACT_FACTOR_DEFAULT = 0.5;
    public static final double HASH_LOAD_FACTOR_MIN = 0.5;
    public static final double HASH_LOAD_FACTOR_MAX = 1.0;
    public static final double HASH_LOAD_FACTOR_DEFAULT = 0.75;
    private boolean _indexesCached = true;
    private int _batchSize = 10000;
    private int _numSyncBatches = 5;
    private int _segmentFileSizeMB = 256;
    private double _segmentCompactFactor = 0.5;
    private double _hashLoadFactor = 0.75;
    public static final String PARAM_INDEXES_CACHED = "krati.store.indexes.cached";
    public static final String PARAM_BATCH_SIZE = "krati.store.batchSize";
    public static final String PARAM_NUM_SYNC_BATCHES = "krati.store.numSyncBatches";
    public static final String PARAM_SEGMENT_FILE_SIZE_MB = "krati.store.segment.file.size";
    public static final String PARAM_SEGMENT_COMPACT_FACTOR = "krati.store.segment.compact.factor";
    public static final String PARAM_SEGMENT_FACTORY_CLASS = "krati.store.segment.factory.class";
    public static final String PARAM_HASH_LOAD_FACTOR = "krati.store.hash.load.factor";
    public static final String PARAM_HASH_FUNCTION_CLASS = "krati.store.hash.function.class";
    public static final String PARAM_INITIAL_CAPACITY = "krati.store.initial.capacity";
    public static final String PARAM_PARTITION_START = "krati.store.partition.start";
    public static final String PARAM_PARTITION_COUNT = "krati.store.partition.count";

    protected StoreParams() {
        this.setBatchSize(10000);
        this.setNumSyncBatches(5);
        this.setSegmentFileSizeMB(256);
        this.setSegmentCompactFactor(0.5);
        this.setHashLoadFactor(0.75);
        this.setIndexesCached(true);
    }

    public void setBatchSize(int batchSize) {
        this._batchSize = batchSize;
        this._properties.setProperty(PARAM_BATCH_SIZE, this._batchSize + "");
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public void setNumSyncBatches(int numSyncBatches) {
        this._numSyncBatches = numSyncBatches;
        this._properties.setProperty(PARAM_NUM_SYNC_BATCHES, this._numSyncBatches + "");
    }

    public int getNumSyncBatches() {
        return this._numSyncBatches;
    }

    public void setSegmentFileSizeMB(int segmentFileSizeMB) {
        this._segmentFileSizeMB = segmentFileSizeMB;
        this._properties.setProperty(PARAM_SEGMENT_FILE_SIZE_MB, this._segmentFileSizeMB + "");
    }

    public int getSegmentFileSizeMB() {
        return this._segmentFileSizeMB;
    }

    public void setSegmentCompactFactor(double segmentCompactFactor) {
        this._segmentCompactFactor = segmentCompactFactor;
        this._properties.setProperty(PARAM_SEGMENT_COMPACT_FACTOR, this._segmentCompactFactor + "");
    }

    public double getSegmentCompactFactor() {
        return this._segmentCompactFactor;
    }

    public void setHashLoadFactor(double hashLoadFactor) {
        this._hashLoadFactor = hashLoadFactor;
        this._properties.setProperty(PARAM_HASH_LOAD_FACTOR, this._hashLoadFactor + "");
    }

    public double getHashLoadFactor() {
        return this._hashLoadFactor;
    }

    public void setIndexesCached(boolean b) {
        this._indexesCached = b;
        this._properties.setProperty(PARAM_INDEXES_CACHED, this._indexesCached ? "true" : "false");
    }

    public boolean getIndexesCached() {
        return this._indexesCached;
    }

    public boolean isIndexesCached() {
        return this._indexesCached;
    }

    public static final int getDynamicStoreInitialLevel(int initialCapacity) {
        if (initialCapacity <= 65536) {
            return 0;
        }
        double d = (double)initialCapacity / 65536.0;
        int level = (int)Math.ceil(Math.log(d) / Math.log(2.0));
        return level;
    }

    public static final int getDynamicStoreInitialCapacity(int initialLevel) {
        LinearHashing h = new LinearHashing(65536);
        h.reinit(Integer.MAX_VALUE);
        int maxLevel = h.getLevel();
        int initialCapacity = 65536;
        if (initialLevel > 0) {
            if (initialLevel > maxLevel) {
                initialLevel = maxLevel;
            }
            initialCapacity = 65536 << initialLevel;
        }
        return initialCapacity;
    }
}

