/*
 * Decompiled with CFR 0.152.
 */
package krati.core;

import java.io.File;
import krati.core.StoreConfig;
import krati.core.StoreParams;
import krati.core.StorePartitionConfig;
import krati.core.segment.SegmentFactory;
import krati.store.ArrayStore;
import krati.store.ArrayStorePartition;
import krati.store.DynamicDataArray;
import krati.store.DynamicDataSet;
import krati.store.DynamicDataStore;
import krati.store.IndexedDataStore;
import krati.store.StaticArrayStorePartition;
import krati.store.StaticDataArray;
import krati.store.StaticDataSet;
import krati.store.StaticDataStore;
import krati.util.FnvHashFunction;

public class StoreFactory {
    public static ArrayStorePartition createArrayStorePartition(StorePartitionConfig config) throws Exception {
        return new StaticArrayStorePartition(config);
    }

    public static ArrayStorePartition createArrayStorePartition(File homeDir, int idStart, int idCount, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        int batchSize = 10000;
        int numSyncBatches = 5;
        double segmentCompactFactor = 0.5;
        return StoreFactory.createArrayStorePartition(homeDir, idStart, idCount, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor);
    }

    public static ArrayStorePartition createArrayStorePartition(File homeDir, int idStart, int idCount, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        double segmentCompactFactor = 0.5;
        return StoreFactory.createArrayStorePartition(homeDir, idStart, idCount, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor);
    }

    public static ArrayStorePartition createArrayStorePartition(File homeDir, int idStart, int idCount, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor) throws Exception {
        return new StaticArrayStorePartition(idStart, idCount, batchSize, numSyncBatches, homeDir, segmentFactory, segmentFileSizeMB, segmentCompactFactor, false);
    }

    public static ArrayStore createStaticArrayStore(StoreConfig config) throws Exception {
        return new StaticDataArray(config);
    }

    public static ArrayStore createStaticArrayStore(File homeDir, int length, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        int batchSize = 10000;
        int numSyncBatches = 5;
        double segmentCompactFactor = 0.5;
        return StoreFactory.createStaticArrayStore(homeDir, length, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor);
    }

    public static ArrayStore createStaticArrayStore(File homeDir, int length, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        double segmentCompactFactor = 0.5;
        return StoreFactory.createStaticArrayStore(homeDir, length, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor);
    }

    public static ArrayStore createStaticArrayStore(File homeDir, int length, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor) throws Exception {
        return new StaticDataArray(length, batchSize, numSyncBatches, homeDir, segmentFactory, segmentFileSizeMB, segmentCompactFactor);
    }

    public static ArrayStore createDynamicArrayStore(StoreConfig config) throws Exception {
        return new DynamicDataArray(config);
    }

    public static ArrayStore createDynamicArrayStore(File homeDir, int initialLength, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        int batchSize = 10000;
        int numSyncBatches = 5;
        double segmentCompactFactor = 0.5;
        return StoreFactory.createDynamicArrayStore(homeDir, initialLength, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor);
    }

    public static ArrayStore createDynamicArrayStore(File homeDir, int initialLength, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        double segmentCompactFactor = 0.5;
        return StoreFactory.createDynamicArrayStore(homeDir, initialLength, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor);
    }

    public static ArrayStore createDynamicArrayStore(File homeDir, int initialLength, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor) throws Exception {
        return new DynamicDataArray(initialLength, batchSize, numSyncBatches, homeDir, segmentFactory, segmentFileSizeMB, segmentCompactFactor);
    }

    public static StaticDataStore createStaticDataStore(StoreConfig config) throws Exception {
        return new StaticDataStore(config);
    }

    public static StaticDataStore createStaticDataStore(File homeDir, int capacity, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        int batchSize = 10000;
        int numSyncBatches = 5;
        double segmentCompactFactor = 0.5;
        return StoreFactory.createStaticDataStore(homeDir, capacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor);
    }

    public static StaticDataStore createStaticDataStore(File homeDir, int capacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        double segmentCompactFactor = 0.5;
        return StoreFactory.createStaticDataStore(homeDir, capacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor);
    }

    public static StaticDataStore createStaticDataStore(File homeDir, int capacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor) throws Exception {
        return new StaticDataStore(homeDir, capacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor, new FnvHashFunction());
    }

    public static DynamicDataStore createDynamicDataStore(StoreConfig config) throws Exception {
        return new DynamicDataStore(config);
    }

    public static DynamicDataStore createDynamicDataStore(File homeDir, int initialCapacity, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        int batchSize = 10000;
        int numSyncBatches = 5;
        double hashLoadFactor = 0.75;
        double segmentCompactFactor = 0.5;
        return StoreFactory.createDynamicDataStore(homeDir, initialCapacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor, hashLoadFactor);
    }

    public static DynamicDataStore createDynamicDataStore(File homeDir, int initialCapacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        double hashLoadFactor = 0.75;
        double segmentCompactFactor = 0.5;
        return StoreFactory.createDynamicDataStore(homeDir, initialCapacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor, hashLoadFactor);
    }

    public static DynamicDataStore createDynamicDataStore(File homeDir, int initialCapacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor) throws Exception {
        double hashLoadFactor = 0.75;
        return StoreFactory.createDynamicDataStore(homeDir, initialCapacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor, hashLoadFactor);
    }

    public static DynamicDataStore createDynamicDataStore(File homeDir, int initialCapacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor, double hashLoadFactor) throws Exception {
        return new DynamicDataStore(homeDir, StoreParams.getDynamicStoreInitialLevel(initialCapacity), batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor, hashLoadFactor, new FnvHashFunction());
    }

    public static IndexedDataStore createIndexedDataStore(File homeDir, int initialCapacity, int indexSegmentFileSizeMB, SegmentFactory indexSegmentFactory, int storeSegmentFileSizeMB, SegmentFactory storeSegmentFactory) throws Exception {
        int batchSize = 10000;
        int numSyncBatches = 5;
        return StoreFactory.createIndexedDataStore(homeDir, initialCapacity, batchSize, numSyncBatches, indexSegmentFileSizeMB, indexSegmentFactory, storeSegmentFileSizeMB, storeSegmentFactory);
    }

    public static IndexedDataStore createIndexedDataStore(File homeDir, int initialCapacity, int batchSize, int numSyncBatches, int indexSegmentFileSizeMB, SegmentFactory indexSegmentFactory, int storeSegmentFileSizeMB, SegmentFactory storeSegmentFactory) throws Exception {
        int initLevel = StoreParams.getDynamicStoreInitialLevel(initialCapacity);
        return new IndexedDataStore(homeDir, batchSize, numSyncBatches, initLevel, indexSegmentFileSizeMB, indexSegmentFactory, initLevel, storeSegmentFileSizeMB, storeSegmentFactory);
    }

    public static StaticDataSet createStaticDataSet(StoreConfig config) throws Exception {
        return new StaticDataSet(config);
    }

    public static StaticDataSet createStaticDataSet(File homeDir, int capacity, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        int batchSize = 10000;
        int numSyncBatches = 5;
        double segmentCompactFactor = 0.5;
        return StoreFactory.createStaticDataSet(homeDir, capacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor);
    }

    public static StaticDataSet createStaticDataSet(File homeDir, int capacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        double segmentCompactFactor = 0.5;
        return StoreFactory.createStaticDataSet(homeDir, capacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor);
    }

    public static StaticDataSet createStaticDataSet(File homeDir, int capacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor) throws Exception {
        return new StaticDataSet(homeDir, capacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor, new FnvHashFunction());
    }

    public static DynamicDataSet createDynamicDataSet(StoreConfig config) throws Exception {
        return new DynamicDataSet(config);
    }

    public static DynamicDataSet createDynamicDataSet(File homeDir, int initialCapacity, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        int batchSize = 10000;
        int numSyncBatches = 5;
        double hashLoadFactor = 0.75;
        double segmentCompactFactor = 0.5;
        return StoreFactory.createDynamicDataSet(homeDir, initialCapacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor, hashLoadFactor);
    }

    public static DynamicDataSet createDynamicDataSet(File homeDir, int initialCapacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        double hashLoadFactor = 0.75;
        double segmentCompactFactor = 0.5;
        return StoreFactory.createDynamicDataSet(homeDir, initialCapacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor, hashLoadFactor);
    }

    public static DynamicDataSet createDynamicDataSet(File homeDir, int initialCapacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor) throws Exception {
        double hashLoadFactor = 0.75;
        return StoreFactory.createDynamicDataSet(homeDir, initialCapacity, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor, hashLoadFactor);
    }

    public static DynamicDataSet createDynamicDataSet(File homeDir, int initialCapacity, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor, double hashLoadFactor) throws Exception {
        return new DynamicDataSet(homeDir, StoreParams.getDynamicStoreInitialLevel(initialCapacity), batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, segmentCompactFactor, hashLoadFactor, new FnvHashFunction());
    }
}

