/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import org.idevlab.rjc.util.KeyUtil;
import org.idevlab.rjc.util.MurmurHash;
import org.idevlab.rjc.util.SafeEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashAlgorithm
extends Enum<HashAlgorithm> {
    public static final /* enum */ HashAlgorithm NATIVE_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm CRC32_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm FNV1_64_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm FNV1A_64_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm FNV1_32_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm FNV1A_32_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm KETAMA_HASH = new HashAlgorithm();
    public static final /* enum */ HashAlgorithm MURMUR_HASH = new HashAlgorithm();
    private static final long FNV_64_INIT = -3750763034362895579L;
    private static final long FNV_64_PRIME = 1099511628211L;
    private static final long FNV_32_INIT = 2166136261L;
    private static final long FNV_32_PRIME = 16777619L;
    private static final /* synthetic */ HashAlgorithm[] $VALUES;

    public static HashAlgorithm[] values() {
        return (HashAlgorithm[])$VALUES.clone();
    }

    public static HashAlgorithm valueOf(String name) {
        return Enum.valueOf(HashAlgorithm.class, name);
    }

    public long hash(String k) {
        long rv = 0L;
        switch (this) {
            case NATIVE_HASH: {
                rv = k.hashCode();
                break;
            }
            case CRC32_HASH: {
                CRC32 crc32 = new CRC32();
                crc32.update(KeyUtil.getKeyBytes(k));
                rv = crc32.getValue() >> 16 & 0x7FFFL;
                break;
            }
            case FNV1_64_HASH: {
                rv = -3750763034362895579L;
                int len = k.length();
                for (int i = 0; i < len; ++i) {
                    rv *= 1099511628211L;
                    rv ^= (long)k.charAt(i);
                }
                break;
            }
            case FNV1A_64_HASH: {
                rv = -3750763034362895579L;
                int len = k.length();
                for (int i = 0; i < len; ++i) {
                    rv ^= (long)k.charAt(i);
                    rv *= 1099511628211L;
                }
                break;
            }
            case FNV1_32_HASH: {
                rv = 2166136261L;
                int len = k.length();
                for (int i = 0; i < len; ++i) {
                    rv *= 16777619L;
                    rv ^= (long)k.charAt(i);
                }
                break;
            }
            case FNV1A_32_HASH: {
                rv = 2166136261L;
                int len = k.length();
                for (int i = 0; i < len; ++i) {
                    rv ^= (long)k.charAt(i);
                    rv *= 16777619L;
                }
                break;
            }
            case KETAMA_HASH: {
                byte[] bKey = HashAlgorithm.computeMd5(k);
                rv = (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
                break;
            }
            case MURMUR_HASH: {
                rv = MurmurHash.hash64A(SafeEncoder.encode(k), 305441741);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return rv & 0xFFFFFFFFL;
    }

    public static byte[] computeMd5(String k) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 not supported", e);
        }
        md5.reset();
        md5.update(KeyUtil.getKeyBytes(k));
        return md5.digest();
    }

    static {
        $VALUES = new HashAlgorithm[]{NATIVE_HASH, CRC32_HASH, FNV1_64_HASH, FNV1A_64_HASH, FNV1_32_HASH, FNV1A_32_HASH, KETAMA_HASH, MURMUR_HASH};
    }
}

