/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.ds;

import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.ds.ConnectionFactory;
import org.idevlab.rjc.ds.ConnectionFactoryImpl;
import org.idevlab.rjc.ds.DataSource;
import org.idevlab.rjc.ds.RedisConnection;

public class SimpleDataSource
implements DataSource {
    private String host;
    private int port = 6379;
    private int timeout = 2000;
    private String password;
    private ConnectionFactory connectionFactory;

    public SimpleDataSource() {
    }

    public SimpleDataSource(String host) {
        this.host = host;
    }

    public SimpleDataSource(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public SimpleDataSource(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public SimpleDataSource(String host, int port, int timeout, String password) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.password = password;
    }

    public synchronized RedisConnection getConnection() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new ConnectionFactoryImpl(this.host, this.port, this.timeout, this.password);
        }
        try {
            return this.connectionFactory.create();
        }
        catch (Exception e) {
            throw new RedisException("Cannot get a connection", e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

