/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.idevlab.rjc.Client;
import org.idevlab.rjc.DebugParams;
import org.idevlab.rjc.ElementScore;
import org.idevlab.rjc.Pipeline;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.RedisMonitor;
import org.idevlab.rjc.Session;
import org.idevlab.rjc.SortingParams;
import org.idevlab.rjc.ZParams;
import org.idevlab.rjc.ds.RedisConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RedisSessionImpl
implements Session {
    private Client client;

    public RedisSessionImpl(RedisConnection connection) {
        this.client = new Client(connection);
    }

    @Override
    public String set(String key, String value) {
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String get(String key) {
        this.client.get(key);
        return this.client.getBulkReply();
    }

    @Override
    public void quit() {
        this.client.quit();
    }

    @Override
    public Boolean exists(String key) {
        this.client.exists(key);
        return this.integerReplayToBoolean();
    }

    @Override
    public Long del(String ... keys) {
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String type(String key) {
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String flushDB() {
        this.client.flushDB();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Set<String> keys(String pattern) {
        this.client.keys(pattern);
        return new HashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public String randomKey() {
        this.client.randomKey();
        return this.client.getBulkReply();
    }

    @Override
    public String rename(String key, String newKey) {
        this.client.rename(key, newKey);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Boolean renamenx(String key, String newKey) {
        this.client.renamenx(key, newKey);
        return this.integerReplayToBoolean();
    }

    @Override
    public Long dbSize() {
        this.client.dbSize();
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean expire(String key, int seconds) {
        this.client.expire(key, seconds);
        return this.integerReplayToBoolean();
    }

    @Override
    public Boolean expireAt(String key, long unixTime) {
        this.client.expireAt(key, unixTime);
        return this.integerReplayToBoolean();
    }

    @Override
    public Long ttl(String key) {
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String select(int index) {
        this.client.select(index);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Boolean move(String key, int dbIndex) {
        this.client.move(key, dbIndex);
        return this.integerReplayToBoolean();
    }

    @Override
    public String flushAll() {
        this.client.flushAll();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String getSet(String key, String value) {
        this.client.getSet(key, value);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> mget(String ... keys) {
        this.client.mget(keys);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Boolean setnx(String key, String value) {
        this.client.setnx(key, value);
        return this.integerReplayToBoolean();
    }

    @Override
    public String setex(String key, int seconds, String value) {
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String mset(String ... keysvalues) {
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Boolean msetnx(String ... keysvalues) {
        this.client.msetnx(keysvalues);
        return this.integerReplayToBoolean();
    }

    @Override
    public Long decrBy(String key, int value) {
        this.client.decrBy(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(String key) {
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(String key, int value) {
        this.client.incrBy(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incr(String key) {
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(String key, String value) {
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String getRange(String key, int start, int end) {
        this.client.getRange(key, start, end);
        return this.client.getBulkReply();
    }

    @Override
    public Long setRange(String key, int offset, String value) {
        this.client.setRange(key, offset, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean hset(String key, String field, String value) {
        this.client.hset(key, field, value);
        return this.integerReplayToBoolean();
    }

    @Override
    public String hget(String key, String field) {
        this.client.hget(key, field);
        return this.client.getBulkReply();
    }

    @Override
    public Boolean hsetnx(String key, String field, String value) {
        this.client.hsetnx(key, field, value);
        return this.integerReplayToBoolean();
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        this.client.hmget(key, fields);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long hincrBy(String key, String field, int value) {
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean hexists(String key, String field) {
        this.client.hexists(key, field);
        return this.integerReplayToBoolean();
    }

    @Override
    public Boolean hdel(String key, String field) {
        this.client.hdel(key, field);
        return this.integerReplayToBoolean();
    }

    @Override
    public Long hlen(String key) {
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> hkeys(String key) {
        this.client.hkeys(key);
        return new HashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public List<String> hvals(String key) {
        this.client.hvals(key);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        this.client.hgetAll(key);
        List<String> flatHash = this.client.getMultiBulkReply();
        HashMap<String, String> hash = new HashMap<String, String>();
        Iterator<String> iterator = flatHash.iterator();
        while (iterator.hasNext()) {
            hash.put(iterator.next(), iterator.next());
        }
        return hash;
    }

    @Override
    public Long rpush(String key, String value) {
        this.client.rpush(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(String key, String value) {
        this.client.lpush(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(String key) {
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> lrange(String key, int start, int end) {
        this.client.lrange(key, start, end);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String ltrim(String key, int start, int end) {
        this.client.ltrim(key, start, end);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String lindex(String key, int index) {
        this.client.lindex(key, index);
        return this.client.getBulkReply();
    }

    @Override
    public String lset(String key, int index, String value) {
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(String key, int count, String value) {
        this.client.lrem(key, count, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String lpop(String key) {
        this.client.lpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public String rpop(String key) {
        this.client.rpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public String rpoplpush(String srckey, String dstkey) {
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBulkReply();
    }

    @Override
    public Boolean sadd(String key, String member) {
        this.client.sadd(key, member);
        return this.integerReplayToBoolean();
    }

    private Boolean integerReplayToBoolean() {
        Long replay = this.client.getIntegerReply();
        if (replay == null) {
            return null;
        }
        return replay == 1L;
    }

    @Override
    public Set<String> smembers(String key) {
        this.client.smembers(key);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Boolean srem(String key, String member) {
        this.client.srem(key, member);
        return this.integerReplayToBoolean();
    }

    @Override
    public String spop(String key) {
        this.client.spop(key);
        return this.client.getBulkReply();
    }

    @Override
    public Boolean smove(String srckey, String dstkey, String member) {
        this.client.smove(srckey, dstkey, member);
        return this.integerReplayToBoolean();
    }

    @Override
    public Long scard(String key) {
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(String key, String member) {
        this.client.sismember(key, member);
        return this.integerReplayToBoolean();
    }

    @Override
    public Set<String> sinter(String ... keys) {
        this.client.sinter(keys);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    @Override
    public Long sinterstore(String dstkey, String ... keys) {
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> sunion(String ... keys) {
        this.client.sunion(keys);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Long sunionstore(String dstkey, String ... keys) {
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> sdiff(String ... keys) {
        this.client.sdiff(keys);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    @Override
    public Long sdiffstore(String dstkey, String ... keys) {
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String srandmember(String key) {
        this.client.srandmember(key);
        return this.client.getBulkReply();
    }

    @Override
    public Boolean zadd(String key, Number score, String member) {
        this.client.zadd(key, score, member);
        return this.integerReplayToBoolean();
    }

    @Override
    public List<String> zrange(String key, int start, int end) {
        this.client.zrange(key, start, end);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Boolean zrem(String key, String member) {
        this.client.zrem(key, member);
        return this.integerReplayToBoolean();
    }

    @Override
    public Long zrank(String key, String member) {
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(String key, String member) {
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> zrevrange(String key, int start, int end) {
        this.client.zrevrange(key, start, end);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<ElementScore> zrangeWithScores(String key, int start, int end) {
        this.client.zrangeWithScores(key, start, end);
        return this.getReplyAsElementScoreSet(this.client);
    }

    @Override
    public List<ElementScore> zrevrangeWithScores(String key, int start, int end) {
        this.client.zrevrangeWithScores(key, start, end);
        return this.getReplyAsElementScoreSet(this.client);
    }

    @Override
    public List<String> zrevrangeByScore(String key, String max, String min) {
        this.client.zrevrangeByScore(key, max, min);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.client.zrevrangeByScore(key, max, min, offset, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<ElementScore> zrevrangeByScoreWithScores(String key, String max, String min) {
        this.client.zrevrangeByScoreWithScores(key, max, min);
        return this.getReplyAsElementScoreSet(this.client);
    }

    @Override
    public List<ElementScore> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getReplyAsElementScoreSet(this.client);
    }

    @Override
    public Long zcard(String key) {
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String zscore(String key, String member) {
        this.client.zscore(key, member);
        return this.client.getBulkReply();
    }

    @Override
    public String watch(String ... keys) {
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String unwatch() {
        this.client.unwatch();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Object> exec() {
        this.client.exec();
        return this.client.getObjectMultiBulkReply();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public List<String> sort(String key) {
        this.client.sort(key);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        this.client.sort(key, sortingParameters);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> blpop(int timeout, String ... keys) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(keys));
        args.add(String.valueOf(timeout));
        this.client.blpop(args.toArray(new String[args.size()]));
        this.client.setTimeoutInfinite();
        List<String> multiBulkReply = this.client.getMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    @Override
    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long sort(String key, String dstkey) {
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> brpop(int timeout, String ... keys) {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(keys));
        args.add(String.valueOf(timeout));
        this.client.brpop(args.toArray(new String[args.size()]));
        this.client.setTimeoutInfinite();
        List<String> multiBulkReply = this.client.getMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    @Override
    public String auth(String password) {
        this.client.auth(password);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long publish(String channel, String message) {
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zcount(String key, Number min, Number max) {
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> zrangeByScore(String key, String min, String max) {
        this.client.zrangeByScore(key, min, max);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        this.client.zrangeByScore(key, min, max, offset, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<ElementScore> zrangeByScoreWithScores(String key, String min, String max) {
        this.client.zrangeByScoreWithScores(key, min, max);
        return this.getReplyAsElementScoreSet(this.client);
    }

    @Override
    public List<ElementScore> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getReplyAsElementScoreSet(this.client);
    }

    private List<ElementScore> getReplyAsElementScoreSet(Client client) {
        List<String> membersWithScores = client.getMultiBulkReply();
        ArrayList<ElementScore> result = new ArrayList<ElementScore>();
        Iterator<String> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            result.add(new ElementScore(iterator.next(), iterator.next()));
        }
        return result;
    }

    @Override
    public Long zremrangeByRank(String key, int start, int end) {
        this.client.zremrangeByRank(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(String dstkey, String ... sets) {
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(String dstkey, String ... sets) {
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long strlen(String key) {
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpushx(String key, String value) {
        this.client.lpushx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean persist(String key) {
        this.client.persist(key);
        return this.integerReplayToBoolean();
    }

    @Override
    public Long rpushx(String key, String value) {
        this.client.rpushx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String echo(String string) {
        this.client.echo(string);
        return this.client.getBulkReply();
    }

    @Override
    public Long linsert(String key, Client.LIST_POSITION where, String pivot, String value) {
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String brpoplpush(String source, String destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        return this.client.getBulkReply();
    }

    @Override
    public Long setBit(String key, int offset, String value) {
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Long getBit(String key, int offset) {
        this.client.getbit(key, offset);
        return this.client.getIntegerReply();
    }

    @Override
    public String ping() {
        this.client.ping();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String zincrby(String key, Number score, String member) {
        this.client.zincrby(key, score, member);
        return this.client.getBulkReply();
    }

    @Override
    public String multi() {
        this.client.multi();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String discard() {
        this.client.discard();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Object> pipeline(Pipeline pipeline) {
        pipeline.execute(this.client);
        return this.client.getAll();
    }

    @Override
    public Long zremrangeByScore(String key, String min, String max) {
        this.client.zremrangeByScore(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public String save() {
        this.client.save();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String bgsave() {
        this.client.bgsave();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String bgrewriteaof() {
        this.client.bgrewriteaof();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lastsave() {
        this.client.lastsave();
        return this.client.getIntegerReply();
    }

    @Override
    public String shutdown() {
        String status;
        this.client.shutdown();
        try {
            status = this.client.getStatusCodeReply();
        }
        catch (RedisException ex) {
            status = null;
        }
        return status;
    }

    @Override
    public String info() {
        this.client.info();
        return this.client.getBulkReply();
    }

    @Override
    public void monitor(RedisMonitor redisMonitor) {
        this.client.monitor();
        do {
            String command = this.client.getBulkReply();
            redisMonitor.onCommand(command);
        } while (this.client.isConnected());
    }

    @Override
    public String slaveof(String host, int port) {
        this.client.slaveof(host, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String slaveofNoOne() {
        this.client.slaveofNoOne();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> configGet(String pattern) {
        this.client.configGet(pattern);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String configSet(String parameter, String value) {
        this.client.configSet(parameter, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public void sync() {
        this.client.sync();
    }

    @Override
    public String debug(DebugParams params) {
        this.client.debug(params);
        return this.client.getStatusCodeReply();
    }
}

