/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.AbstractSerializer;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.DefaultSerializer;
import com.hazelcast.nio.FastByteArrayInputStream;
import com.hazelcast.nio.FastByteArrayOutputStream;
import com.hazelcast.nio.TypeSerializer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Serializer
extends AbstractSerializer {
    private static final byte SERIALIZER_TYPE_DATA = 0;

    public Serializer() {
        super(new DataSerializer(), new DefaultSerializer());
    }

    public static Object newInstance(Class klass) throws Exception {
        return AbstractSerializer.newInstance(klass);
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        return AbstractSerializer.classForName(className);
    }

    public static Class<?> classForName(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return AbstractSerializer.classForName(classLoader, className);
    }

    public Data writeObject(Object obj) {
        if (obj instanceof Data) {
            return (Data)obj;
        }
        byte[] bytes = this.toByteArray(obj);
        if (bytes == null) {
            return null;
        }
        return new Data(bytes);
    }

    public Object readObject(Data data) {
        if (data == null || data.buffer == null || data.buffer.length == 0) {
            return null;
        }
        byte[] byteArray = data.buffer;
        Object obj = this.toObject(byteArray);
        if (obj instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)obj).setHazelcastInstance(ThreadContext.get().getCurrentFactory());
        }
        return obj;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataSerializer
    implements TypeSerializer<DataSerializable> {
        @Override
        public final int priority() {
            return 0;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof DataSerializable;
        }

        @Override
        public final byte getTypeId() {
            return 0;
        }

        protected Class classForName(String className) throws ClassNotFoundException {
            return AbstractSerializer.classForName(className);
        }

        protected String toClassName(Class clazz) throws ClassNotFoundException {
            return clazz.getName();
        }

        @Override
        public final DataSerializable read(FastByteArrayInputStream bbis) throws Exception {
            String className = bbis.readUTF();
            try {
                DataSerializable ds = (DataSerializable)Serializer.newInstance(this.classForName(className));
                ds.readData(bbis);
                return ds;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Problem reading DataSerializable class : " + className + ", exception: " + e);
            }
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, DataSerializable obj) throws Exception {
            bbos.writeUTF(this.toClassName(obj.getClass()));
            obj.writeData(bbos);
        }
    }
}

