/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemListener;
import com.hazelcast.jmx.AbstractMBean;
import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import com.hazelcast.jmx.JMXOperation;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.ObjectNameSpec;
import com.hazelcast.jmx.StatisticsCollector;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMXDescription(value="A distributed set")
public class SetMBean
extends AbstractMBean<ISet<?>> {
    protected ItemListener listener;
    private StatisticsCollector receivedStats = null;
    private StatisticsCollector servedStats = null;

    public SetMBean(ISet<?> managedObject, ManagementService managementService) {
        super(managedObject, managementService);
    }

    @Override
    public ObjectNameSpec getNameSpec() {
        return this.getParentName().getNested("Set", this.getName());
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        if (!registrationDone.booleanValue()) {
            return;
        }
        if (this.managementService.showDetails()) {
            this.receivedStats = ManagementService.newStatisticsCollector();
            this.servedStats = ManagementService.newStatisticsCollector();
            this.listener = new ItemListener(){

                public void itemAdded(Object item) {
                    SetMBean.this.receivedStats.addEvent();
                    SetMBean.this.addItem(item);
                }

                public void itemRemoved(Object item) {
                    SetMBean.this.servedStats.addEvent();
                    SetMBean.this.removeItem(item);
                }
            };
            ((ISet)this.getManagedObject()).addItemListener(this.listener, false);
            for (Object item : (ISet)this.getManagedObject()) {
                this.addItem(item);
            }
        }
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.listener != null) {
            ((ISet)this.getManagedObject()).removeItemListener(this.listener);
            this.listener = null;
        }
        if (this.receivedStats != null) {
            this.receivedStats.destroy();
            this.receivedStats = null;
        }
        if (this.servedStats != null) {
            this.servedStats.destroy();
            this.servedStats = null;
        }
        super.preDeregister();
    }

    protected void addItem(Object item) {
    }

    protected void removeItem(Object item) {
    }

    @JMXOperation(value="resetStats")
    public void resetStats() {
        if (this.receivedStats != null) {
            this.receivedStats.reset();
        }
        if (this.servedStats != null) {
            this.servedStats.reset();
        }
    }

    @JMXOperation(value="clear")
    @JMXDescription(value="Clear set")
    public void clear() {
        ((ISet)this.getManagedObject()).clear();
    }

    @JMXAttribute(value="Name")
    @JMXDescription(value="Registration name of the list")
    public String getName() {
        return ((ISet)this.getManagedObject()).getName();
    }

    @JMXAttribute(value="Size")
    @JMXDescription(value="Current size")
    public int getSize() {
        return ((ISet)this.getManagedObject()).size();
    }

    @JMXAttribute(value="Items")
    @JMXDescription(value="Current items")
    public List<?> getItems() {
        ArrayList result = new ArrayList();
        for (Object item : (ISet)this.getManagedObject()) {
            result.add(item);
        }
        return result;
    }

    @JMXAttribute(value="ObjectAdded")
    @JMXDescription(value="Object added to the util since the start time")
    public long getItemsReceived() {
        return this.receivedStats.getTotal();
    }

    @JMXAttribute(value="ObjectRemoved")
    @JMXDescription(value="Object removed from the util since the start time")
    public long getItemsServed() {
        return this.servedStats.getTotal();
    }
}

