/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Instance;
import com.hazelcast.core.Semaphore;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import java.util.concurrent.TimeUnit;

public class SemaphoreImpl
extends FactoryAwareNamedProxy
implements Semaphore {
    Semaphore base = null;
    Data nameAsData = null;

    public SemaphoreImpl() {
    }

    public SemaphoreImpl(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
        this.base = new SemaphoreReal();
    }

    Data getNameAsData() {
        if (this.nameAsData == null) {
            this.nameAsData = IOUtil.toData(this.name);
        }
        return this.nameAsData;
    }

    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public void destroy() {
        this.ensure();
        this.base.destroy();
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.SEMAPHORE;
    }

    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        this.ensure();
        return this.base.tryAcquire(permits, timeout, unit);
    }

    public boolean tryAcquire(int permits) {
        this.ensure();
        return this.base.tryAcquire(permits);
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) {
        this.ensure();
        return this.base.tryAcquire(timeout, unit);
    }

    public boolean tryAcquire() {
        this.ensure();
        return this.base.tryAcquire();
    }

    public void release(int permits) {
        this.ensure();
        this.base.release(permits);
    }

    public void release() {
        this.ensure();
        this.base.release();
    }

    public int drainPermits() {
        this.ensure();
        return this.base.drainPermits();
    }

    public int availablePermits() {
        this.ensure();
        return this.base.availablePermits();
    }

    public void acquireUninterruptibly(int permits) {
        this.ensure();
        this.base.acquireUninterruptibly(permits);
    }

    public void acquireUninterruptibly() {
        this.ensure();
        this.base.acquireUninterruptibly();
    }

    public void acquire(int permits) throws InterruptedException {
        this.ensure();
        this.base.acquire(permits);
    }

    public void acquire() throws InterruptedException {
        this.ensure();
        this.base.acquire();
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (Semaphore)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    private class SemaphoreReal
    implements Semaphore {
        private SemaphoreReal() {
        }

        ConcurrentMapManager.MSemaphore newMSemaphore(ClusterOperation op, int value) {
            ConcurrentMapManager concurrentMapManager = ((SemaphoreImpl)SemaphoreImpl.this).factory.node.concurrentMapManager;
            concurrentMapManager.getClass();
            return concurrentMapManager.new ConcurrentMapManager.MSemaphore(SemaphoreImpl.this.getNameAsData(), op, value);
        }

        public void acquire() throws InterruptedException {
            this.tryAcquire();
        }

        public void acquireUninterruptibly() {
            this.tryAcquire();
        }

        public boolean tryAcquire(int permits) {
            return this.tryAcquire(permits, -1L, TimeUnit.MILLISECONDS);
        }

        public boolean tryAcquire() {
            return this.tryAcquire(1);
        }

        public boolean tryAcquire(long timeout, TimeUnit unit) {
            return this.tryAcquire(1, timeout, unit);
        }

        public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
            ConcurrentMapManager.MSemaphore s = this.newMSemaphore(ClusterOperation.SEMAPHORE_ACQUIRE, 1);
            return s.tryAcquire(permits, timeout, unit);
        }

        public void release() {
            this.release(1);
        }

        public void acquire(int permits) throws InterruptedException {
            this.tryAcquire(permits);
        }

        public void acquireUninterruptibly(int permits) {
            this.tryAcquire(permits);
        }

        public void release(int permits) {
            ConcurrentMapManager.MSemaphore s = this.newMSemaphore(ClusterOperation.SEMAPHORE_RELEASE, 1);
            s.tryRelease(permits, -1L, TimeUnit.MILLISECONDS);
        }

        public int availablePermits() {
            ConcurrentMapManager.MSemaphore s = this.newMSemaphore(ClusterOperation.SEMAPHORE_AVAILABLE_PERIMITS, 0);
            int result = s.availablePermits();
            return result;
        }

        public int drainPermits() {
            ConcurrentMapManager.MSemaphore s = this.newMSemaphore(ClusterOperation.SEMAPHORE_DRAIN_PERIMITS, 0);
            s.availablePermits();
            return (Integer)s.getResult();
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.SEMAPHORE;
        }

        public void destroy() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object getId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

