/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.ExecutionLoadBalancer;
import com.hazelcast.impl.RoundRobinLoadBalancer;
import com.hazelcast.impl.executor.ParallelExecutor;

public class NamedExecutorService {
    private final String name;
    private final ParallelExecutor parallelExecutor;
    private final ExecutionLoadBalancer executionLoadBalancer;

    public NamedExecutorService(String name, ParallelExecutor parallelExecutor) {
        this.name = name;
        this.parallelExecutor = parallelExecutor;
        this.executionLoadBalancer = new RoundRobinLoadBalancer();
    }

    public void appendState(StringBuffer sbState) {
        sbState.append("\nExecutor." + this.name + ".size=" + this.parallelExecutor.getPoolSize());
    }

    public void stop() {
        this.parallelExecutor.shutdown();
    }

    public void execute(Runnable runnable) {
        this.parallelExecutor.execute(runnable);
    }

    public void executeOrderedRunnable(int hash, Runnable runnable) {
        this.parallelExecutor.execute(runnable, hash);
    }

    public ExecutionLoadBalancer getExecutionLoadBalancer() {
        return this.executionLoadBalancer;
    }
}

