/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PluggableSchemaResolver
implements EntityResolver {
    public static final String DEFAULT_SCHEMA_MAPPINGS_LOCATION = "META-INF/spring.schemas";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$xml$PluggableSchemaResolver == null ? (class$org$springframework$beans$factory$xml$PluggableSchemaResolver = PluggableSchemaResolver.class$("org.springframework.beans.factory.xml.PluggableSchemaResolver")) : class$org$springframework$beans$factory$xml$PluggableSchemaResolver));
    private final ClassLoader classLoader;
    private final Properties schemaMappings;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$PluggableSchemaResolver;

    public PluggableSchemaResolver(ClassLoader classLoader) {
        this(classLoader, DEFAULT_SCHEMA_MAPPINGS_LOCATION);
    }

    public PluggableSchemaResolver(ClassLoader classLoader, String schemaMappingsLocation) {
        Assert.hasText((String)schemaMappingsLocation, (String)"'schemaMappingsLocation' must not be empty");
        this.classLoader = classLoader;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loading schema mappings from [" + schemaMappingsLocation + "]"));
        }
        try {
            this.schemaMappings = PropertiesLoaderUtils.loadAllProperties((String)schemaMappingsLocation, (ClassLoader)classLoader);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loaded schema mappings: " + this.schemaMappings));
            }
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to load schema mappings from location [" + schemaMappingsLocation + "]", e);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        String resourceLocation;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Trying to resolve XML entity with public id [" + publicId + "] and system id [" + systemId + "]"));
        }
        if (systemId != null && (resourceLocation = this.schemaMappings.getProperty(systemId)) != null) {
            ClassPathResource resource = new ClassPathResource(resourceLocation, this.classLoader);
            InputSource source = new InputSource(resource.getInputStream());
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found XML schema [" + systemId + "] in classpath: " + resourceLocation));
            }
            return source;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

