/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.wrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.common.io.PumpStreamHandler;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandComponent(id="wrapper:install", description="Installs this ServiceMix instance as a service in your operating systems.")
public class InstallCommand
extends OsgiCommandSupport {
    @Option(name="-n", aliases={"--name"}, description="The service name that will be used when installing the service.")
    private String name = "servicemix";
    @Option(name="-d", aliases={"--display"}, description="The display name of the service.")
    private String displayName;
    @Option(name="-D", aliases={"--description"}, description="The description of the service.")
    private String description = "";
    @Option(name="-s", aliases={"--start-type"}, description="Mode in which the service is installed.  AUTO_START or DEMAND_START")
    private String startType = "AUTO_START";

    protected Object doExecute() throws Exception {
        try {
            File file;
            String name = this.getName();
            File base = new File(System.getProperty("servicemix.base"));
            File bin = new File(base, "bin");
            File etc = new File(base, "etc");
            File lib = new File(base, "lib");
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("${servicemix.home}", System.getProperty("servicemix.home"));
            props.put("${servicemix.base}", base.getPath());
            props.put("${name}", name);
            props.put("${displayName}", this.getDisplayName());
            props.put("${description}", this.getDescription());
            props.put("${startType}", this.getStartType());
            String os = System.getProperty("os.name", "Unknown");
            File serviceFile = null;
            if (os.startsWith("Win")) {
                this.mkdir(bin);
                this.copyResourceTo(new File(bin, name + "-wrapper.exe"), "windows/servicemix-wrapper.exe", false);
                serviceFile = new File(bin, name + "-service.bat");
                this.copyFilteredResourceTo(serviceFile, "windows/servicemix-service.bat", props);
                this.mkdir(lib);
                this.copyResourceTo(new File(bin, "wrapper.dll"), "windows/wrapper.dll", false);
            } else if (os.startsWith("Mac OS X")) {
                this.mkdir(bin);
                file = new File(bin, name + "-wrapper");
                this.copyResourceTo(file, "macosx/servicemix-wrapper", false);
                this.chmod(file, "a+x");
                serviceFile = new File(bin, name + "-service");
                this.copyFilteredResourceTo(serviceFile, "unix/servicemix-service", props);
                this.chmod(serviceFile, "a+x");
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "libwrapper.jnilib"), "macosx/libwrapper.jnilib", false);
            } else if (os.startsWith("Linux")) {
                this.mkdir(bin);
                file = new File(bin, name + "-wrapper");
                this.copyResourceTo(file, "linux/servicemix-wrapper", false);
                this.chmod(file, "a+x");
                serviceFile = new File(bin, name + "-service");
                this.copyFilteredResourceTo(serviceFile, "unix/servicemix-service", props);
                this.chmod(serviceFile, "a+x");
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "libwrapper.so"), "linux/libwrapper.so", false);
            } else {
                this.io.out.println("Your operating system '" + os + "' is not currently supported.");
                return 1;
            }
            this.mkdir(lib);
            this.copyResourceTo(new File(lib, "servicemix-wrapper.jar"), "all/servicemix-wrapper.jar", false);
            this.mkdir(etc);
            File wrapperConf = new File(etc, name + "-wrapper.conf");
            this.copyFilteredResourceTo(wrapperConf, "all/servicemix-wrapper.conf", props);
            this.io.out.println("");
            this.io.out.println("Setup complete.  You may want to tweak the JVM properties in the wrapper configuration file: " + wrapperConf.getPath());
            this.io.out.println("before installing and starting the service.");
            this.io.out.println("");
            if (os.startsWith("Win")) {
                this.io.out.println("");
                this.io.out.println("To install the service, run: ");
                this.io.out.println("  C:> " + serviceFile.getPath() + " install");
                this.io.out.println("");
                this.io.out.println("Once installed, to start the service run: ");
                this.io.out.println("  C:> net start \"" + name + "\"");
                this.io.out.println("");
                this.io.out.println("Once running, to stop the service run: ");
                this.io.out.println("  C:> net stop \"" + name + "\"");
                this.io.out.println("");
                this.io.out.println("Once stopped, to remove the installed the service run: ");
                this.io.out.println("  C:> " + serviceFile.getPath() + " remove");
                this.io.out.println("");
            } else if (os.startsWith("Mac OS X")) {
                this.io.out.println("");
                this.io.out.println("At this time it is not known how to get this service to start when the machine is rebooted.");
                this.io.out.println("If you know how to install the following service script so that it gets started");
                this.io.out.println("when OS X starts, please email dev@servicemix.apache.org and let us know how so");
                this.io.out.println("we can update this message.");
                this.io.out.println(" ");
                this.io.out.println("  To start the service:");
                this.io.out.println("    $ " + serviceFile.getPath() + " start");
                this.io.out.println("");
                this.io.out.println("  To stop the service:");
                this.io.out.println("    $ " + serviceFile.getPath() + " stop");
                this.io.out.println("");
            } else if (os.startsWith("Linux")) {
                this.io.out.println("The way the service is installed depends upon your flavor of Linux.");
                this.io.out.println("");
                this.io.out.println("@|cyan On Redhat/Fedora/CentOS Systems:|");
                this.io.out.println("  To install the service:");
                this.io.out.println("    $ ln -s " + serviceFile.getPath() + " /etc/init.d/");
                this.io.out.println("    $ chkconfig " + serviceFile.getName() + " --add");
                this.io.out.println("");
                this.io.out.println("  To start the service when the machine is rebooted:");
                this.io.out.println("    $ chkconfig " + serviceFile.getName() + " on");
                this.io.out.println("");
                this.io.out.println("  To disable starting the service when the machine is rebooted:");
                this.io.out.println("    $ chkconfig " + serviceFile.getName() + " off");
                this.io.out.println("");
                this.io.out.println("  To start the service:");
                this.io.out.println("    $ service " + serviceFile.getName() + " start");
                this.io.out.println("");
                this.io.out.println("  To stop the service:");
                this.io.out.println("    $ service " + serviceFile.getName() + " stop");
                this.io.out.println("");
                this.io.out.println("  To uninstall the service :");
                this.io.out.println("    $ chkconfig " + serviceFile.getName() + " --del");
                this.io.out.println("    $ rm /etc/init.d/" + serviceFile.getName());
                this.io.out.println("");
                this.io.out.println("@|cyan On Ubuntu/Debian Systems:|");
                this.io.out.println("  To install the service:");
                this.io.out.println("    $ ln -s " + serviceFile.getPath() + " /etc/init.d/");
                this.io.out.println("");
                this.io.out.println("  To start the service when the machine is rebooted:");
                this.io.out.println("    $ update-rc.d " + serviceFile.getName() + " defaults");
                this.io.out.println("");
                this.io.out.println("  To disable starting the service when the machine is rebooted:");
                this.io.out.println("    $ update-rc.d -f " + serviceFile.getName() + " remove");
                this.io.out.println("");
                this.io.out.println("  To start the service:");
                this.io.out.println("    $ /etc/init.d/" + serviceFile.getName() + " start");
                this.io.out.println("");
                this.io.out.println("  To stop the service:");
                this.io.out.println("    $ /etc/init.d/" + serviceFile.getName() + " stop");
                this.io.out.println("");
                this.io.out.println("  To uninstall the service :");
                this.io.out.println("    $ rm /etc/init.d/" + serviceFile.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return 0;
    }

    private int chmod(File serviceFile, String mode) throws Exception {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("chmod", mode, serviceFile.getCanonicalPath());
        Process p = builder.start();
        PumpStreamHandler handler = new PumpStreamHandler(this.io.inputStream, this.io.outputStream, this.io.errorStream);
        handler.attach(p);
        handler.start();
        int status = p.waitFor();
        handler.stop();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceTo(File outFile, String resource, boolean text) throws Exception {
        if (!outFile.exists()) {
            this.io.out.println("Creating file: @|green " + outFile.getPath() + "|");
            InputStream is = InstallCommand.class.getResourceAsStream(resource);
            try {
                if (text) {
                    PrintStream out = new PrintStream(new FileOutputStream(outFile));
                    try {
                        Scanner scanner = new Scanner(is);
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            this.io.out.println("writing: " + line);
                            out.println(line);
                        }
                    }
                    finally {
                        this.safeClose(out);
                    }
                }
                FileOutputStream out = new FileOutputStream(outFile);
                try {
                    int c = 0;
                    while ((c = is.read()) >= 0) {
                        out.write(c);
                    }
                }
                finally {
                    this.safeClose(out);
                }
            }
            finally {
                this.safeClose(is);
            }
        } else {
            this.io.out.println("@|red File allready exists|. Move it out of the way if you want it re-created: " + outFile.getPath() + "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFilteredResourceTo(File outFile, String resource, HashMap<String, String> props) throws Exception {
        block8: {
            if (!outFile.exists()) {
                this.io.out.println("Creating file: @|green " + outFile.getPath() + "|");
                InputStream is = InstallCommand.class.getResourceAsStream(resource);
                try {
                    PrintStream out = new PrintStream(new FileOutputStream(outFile));
                    try {
                        Scanner scanner = new Scanner(is);
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            line = this.filter(line, props);
                            out.println(line);
                        }
                        break block8;
                    }
                    finally {
                        this.safeClose(out);
                    }
                }
                finally {
                    this.safeClose(is);
                }
            }
            this.io.out.println("@|red File allready exists|. Move it out of the way if you want it re-created: " + outFile.getPath() + "");
        }
    }

    private void safeClose(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String filter(String line, HashMap<String, String> props) {
        for (Map.Entry<String, String> i : props.entrySet()) {
            int p1 = line.indexOf(i.getKey());
            if (p1 < 0) continue;
            String l1 = line.substring(0, p1);
            String l2 = line.substring(p1 + i.getKey().length());
            line = l1 + i.getValue() + l2;
        }
        return line;
    }

    private void mkdir(File file) {
        if (!file.exists()) {
            this.io.out.println("Creating missing directory: @|green " + file.getPath() + "|");
            file.mkdirs();
        }
    }

    public String getName() {
        if (this.name == null) {
            File base = new File(System.getProperty("servicemix.base"));
            this.name = base.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.getName();
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStartType() {
        return this.startType;
    }

    public void setStartType(String startType) {
        this.startType = startType;
    }
}

