/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.artifacts;

import java.io.IOException;
import javax.jbi.JBIException;
import javax.jbi.management.LifeCycleMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.events.LifeCycleEvent;
import org.apache.servicemix.jbi.deployer.events.LifeCycleListener;
import org.apache.servicemix.jbi.deployer.impl.Storage;
import org.apache.servicemix.nmr.api.event.ListenerRegistry;

public abstract class AbstractLifecycleJbiArtifact
implements LifeCycleMBean {
    public static final String STATE = "state";
    protected final Log LOGGER = LogFactory.getLog(this.getClass());
    protected State state = State.Unknown;
    protected Storage storage;
    protected State runningState;
    protected ListenerRegistry listenerRegistry;

    public State getState() {
        return this.state;
    }

    public State getRunningState() {
        return this.runningState;
    }

    public ListenerRegistry getListenerRegistry() {
        return this.listenerRegistry;
    }

    public void setListenerRegistry(ListenerRegistry listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    public String getCurrentState() {
        switch (this.state) {
            case Started: {
                return "Started";
            }
            case Stopped: {
                return "Stopped";
            }
            case Shutdown: {
                return "Shutdown";
            }
        }
        return "Unknown";
    }

    protected State loadState(State def) {
        return State.valueOf(this.storage.get(STATE, def.name()));
    }

    protected void saveState() {
        this.storage.put(STATE, this.state.name());
        try {
            this.storage.save();
        }
        catch (IOException e) {
            this.LOGGER.warn((Object)"Unable to persist state", (Throwable)e);
        }
        this.runningState = this.state;
    }

    protected void fireEvent(LifeCycleEvent.LifeCycleEventType type) throws JBIException {
        this.fireEvent(type, false);
    }

    protected void fireEvent(LifeCycleEvent.LifeCycleEventType type, boolean force) throws JBIException {
        if (this.listenerRegistry != null) {
            LifeCycleEvent event = null;
            for (LifeCycleListener listener : this.listenerRegistry.getListeners(LifeCycleListener.class)) {
                if (event == null) {
                    event = new LifeCycleEvent(type, this, force);
                }
                listener.lifeCycleChanged(event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        Unknown,
        Started,
        Stopped,
        Shutdown;

    }
}

