/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.task;

import java.io.File;
import org.apache.servicemix.jbi.deployer.AdminCommandsService;
import org.apache.servicemix.jbi.deployer.task.JbiTask;
import org.apache.tools.ant.BuildException;

public class InstallSharedLibraryTask
extends JbiTask {
    private String file;
    private boolean deferExceptions;

    public boolean isDeferExceptions() {
        return this.deferExceptions;
    }

    public void setDeferExceptions(boolean deferExceptions) {
        this.deferExceptions = deferExceptions;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void doExecute(AdminCommandsService acs) throws Exception {
        if (this.file == null) {
            throw new BuildException("null file - file should be an archive");
        }
        if (!this.file.endsWith(".zip") && !this.file.endsWith(".jar")) {
            throw new BuildException("file: " + this.file + " is not an archive");
        }
        File archive = new File(this.file);
        String location = archive.getAbsolutePath();
        if (!archive.isFile()) {
            location = this.file;
        }
        acs.installSharedLibrary(location, this.deferExceptions);
    }
}

