/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.jbi.JBIException;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.artifacts.SharedLibraryImpl;
import org.apache.servicemix.jbi.deployer.descriptor.ClassPath;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryDesc;
import org.apache.servicemix.jbi.deployer.impl.AbstractInstaller;
import org.apache.servicemix.jbi.deployer.impl.Deployer;
import org.apache.servicemix.jbi.deployer.utils.FileUtil;
import org.apache.servicemix.jbi.deployer.utils.ManagementSupport;
import org.apache.xbean.classloader.MultiParentClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

public class SharedLibraryInstaller
extends AbstractInstaller {
    public SharedLibraryInstaller(Deployer deployer, Descriptor descriptor, File jbiArtifact, boolean autoStart) {
        super(deployer, descriptor, jbiArtifact, autoStart);
        this.installRoot = new File(System.getProperty("karaf.base"), "data/jbi/" + this.getName() + "/install");
        this.installRoot.mkdirs();
    }

    public String getName() {
        return this.descriptor.getSharedLibrary().getIdentification().getName();
    }

    public ObjectName install() throws JBIException {
        try {
            SharedLibraryImpl sl = this.deployer.registerSharedLibrary(this.bundle, this.descriptor.getSharedLibrary(), this.createClassLoader());
            return (ObjectName)this.deployer.getManagementStrategy().getManagedObjectName((Object)sl, null, ObjectName.class);
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e.getMessage());
            throw new JBIException((Throwable)e);
        }
    }

    public void uninstall() throws JBIException {
        try {
            this.uninstall(false);
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
    }

    public void stop(boolean force) throws Exception {
    }

    public void uninstall(boolean force) throws Exception {
        this.stop(force);
        SharedLibraryImpl library = this.deployer.getSharedLibrary(this.getName());
        if (library == null && !force) {
            throw ManagementSupport.failure("uninstallSharedLibrary", "SharedLibrary '" + this.getName() + "' is not installed.");
        }
        if (library.getComponents().length > 0 && !force) {
            StringBuilder sb = new StringBuilder();
            for (Component comp : library.getComponents()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(comp.getName());
            }
            throw ManagementSupport.failure("uninstallSharedLibrary", "Shared library " + this.getName() + " is in use by components " + sb.toString());
        }
        this.deployer.unregisterSharedLibrary(library);
        try {
            this.deletePreferences();
        }
        catch (BackingStoreException e) {
            this.LOGGER.warn((Object)("Error cleaning persistent state for component: " + this.getName()), (Throwable)e);
        }
        this.uninstallBundle();
        FileUtil.deleteFile(this.installRoot);
    }

    protected ClassLoader createClassLoader() {
        SharedLibraryDesc library = this.descriptor.getSharedLibrary();
        BundleDelegatingClassLoader parent = BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)this.bundle, (ClassLoader)this.getClass().getClassLoader());
        boolean parentFirst = library.isParentFirstClassLoaderDelegation();
        ClassPath cp = library.getSharedLibraryClassPath();
        String[] classPathNames = cp.getPathElements();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String classPathName : classPathNames) {
            File f = new File(this.installRoot, classPathName);
            if (!f.exists()) {
                this.LOGGER.warn((Object)("Shared library classpath entry not found: '" + classPathName + "'"));
            }
            try {
                urls.add(f.getCanonicalFile().toURL());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Shared library classpath entry not found: '" + classPathName + "'");
            }
        }
        return new MultiParentClassLoader(library.getIdentification().getName(), urls.toArray(new URL[urls.size()]), (ClassLoader)parent, !parentFirst, new String[0], new String[]{"java.", "javax."});
    }
}

