/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.jbi.management.DeploymentServiceMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.ServiceUnit;
import org.apache.servicemix.jbi.deployer.artifacts.ComponentImpl;
import org.apache.servicemix.jbi.deployer.artifacts.ServiceAssemblyImpl;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.descriptor.DescriptorFactory;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceAssemblyDesc;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceUnitDesc;
import org.apache.servicemix.jbi.deployer.handler.Transformer;
import org.apache.servicemix.jbi.deployer.impl.AbstractInstaller;
import org.apache.servicemix.jbi.deployer.impl.Deployer;
import org.apache.servicemix.jbi.deployer.impl.ServiceAssemblyInstaller;
import org.apache.servicemix.jbi.deployer.utils.ManagementSupport;
import org.osgi.framework.BundleContext;

public class DeploymentService
implements DeploymentServiceMBean {
    private static final Log LOG = LogFactory.getLog(DeploymentService.class);
    private Deployer deployer;
    private BundleContext bundleContext;

    public Deployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String deploy(String saZipURL) throws Exception {
        return this.deploy(saZipURL, false);
    }

    public String deploy(String saZipURL, boolean autoStart) throws Exception {
        try {
            if (saZipURL == null) {
                throw ManagementSupport.failure("deploy", "saZipURL must not be null");
            }
            File jarfile = new File(saZipURL);
            if (jarfile.exists() && jarfile.isFile()) {
                Descriptor root;
                try {
                    root = Transformer.getDescriptor(jarfile);
                }
                catch (Exception e) {
                    throw ManagementSupport.failure("deploy", "Unable to build jbi descriptor: " + saZipURL, e);
                }
                if (root == null) {
                    throw ManagementSupport.failure("deploy", "Unable to find jbi descriptor: " + saZipURL);
                }
                DescriptorFactory.checkDescriptor(root);
                ServiceAssemblyDesc sa = root.getServiceAssembly();
                if (sa == null) {
                    throw ManagementSupport.failure("deploy", "JBI descriptor is not an assembly descriptor: " + saZipURL);
                }
                this.checkSus(sa.getServiceUnits());
                String name = sa.getIdentification().getName();
                LOG.info((Object)("Deploy ServiceAssembly " + name));
                ServiceAssemblyInstaller installer = new ServiceAssemblyInstaller(this.deployer, root, jarfile, autoStart);
                installer.installBundle();
                installer.init();
                installer.install();
                return ManagementSupport.createSuccessMessage("deploy SA", name);
            }
            throw new RuntimeException("location for deployment SA: " + saZipURL + " isn't a valid file");
        }
        catch (Exception e) {
            LOG.error((Object)"Error deploying service assembly", (Throwable)e);
            throw e;
        }
    }

    private void checkSus(ServiceUnitDesc[] sus) throws Exception {
        if (sus != null) {
            for (int i = 0; i < sus.length; ++i) {
                String suName = sus[i].getIdentification().getName();
                String componentName = sus[i].getTarget().getComponentName();
                ComponentImpl component = this.deployer.getComponent(componentName);
                if (component == null) {
                    throw ManagementSupport.failure("deploy", "Target component " + componentName + " for service unit " + suName + " is not installed");
                }
                if (!component.getCurrentState().equals("Started")) {
                    throw ManagementSupport.failure("deploy", "Target component " + componentName + " for service unit " + suName + " is not started");
                }
                if (component.getComponent().getServiceUnitManager() == null) {
                    throw ManagementSupport.failure("deploy", "Target component " + componentName + " for service unit " + suName + " does not accept deployments");
                }
                if (!this.isDeployedServiceUnit(componentName, suName)) continue;
                throw ManagementSupport.failure("deploy", "Service unit " + suName + " is already deployed on component " + componentName);
            }
        }
    }

    public String undeploy(String saName) throws Exception {
        ServiceAssemblyImpl assembly = this.deployer.getServiceAssembly(saName);
        if (assembly == null) {
            throw ManagementSupport.failure("undeploy", "SA has not been deployed: " + saName);
        }
        AbstractInstaller installer = this.deployer.getInstaller(assembly);
        if (installer == null) {
            throw ManagementSupport.failure("undeploy", "Could not find service assembly installer: " + saName);
        }
        installer.uninstall(false);
        return ManagementSupport.createSuccessMessage("undeploy", "Service assembly " + saName + " undeployed");
    }

    public String[] getDeployedServiceUnitList(String componentName) throws Exception {
        ComponentImpl component = this.deployer.getComponent(componentName);
        ServiceUnit[] serviceUnits = component.getServiceUnits();
        String[] sus = new String[serviceUnits.length];
        for (int i = 0; i < serviceUnits.length; ++i) {
            sus[i] = serviceUnits[i].getName();
        }
        return sus;
    }

    public String[] getDeployedServiceAssemblies() throws Exception {
        Set<String> sas = this.deployer.getServiceAssemblies().keySet();
        return sas.toArray(new String[sas.size()]);
    }

    public String getServiceAssemblyDescriptor(String saName) throws Exception {
        ServiceAssemblyImpl sa = this.deployer.getServiceAssembly(saName);
        return sa != null ? sa.getDescriptor() : null;
    }

    public boolean canDeployToComponent(String componentName) {
        ComponentImpl component = this.deployer.getComponent(componentName);
        return component != null && "Started".equals(component.getCurrentState()) && component.getComponent().getServiceUnitManager() != null;
    }

    public String start(String serviceAssemblyName) throws Exception {
        try {
            ServiceAssemblyImpl sa = this.deployer.getServiceAssembly(serviceAssemblyName);
            if (sa == null) {
                throw ManagementSupport.failure("start", "SA does not exist: " + serviceAssemblyName);
            }
            sa.start();
            return ManagementSupport.createSuccessMessage("start service assembly successfully", serviceAssemblyName);
        }
        catch (Exception e) {
            LOG.info((Object)"Error in start", (Throwable)e);
            throw e;
        }
    }

    public String stop(String serviceAssemblyName) throws Exception {
        try {
            ServiceAssemblyImpl sa = this.deployer.getServiceAssembly(serviceAssemblyName);
            if (sa == null) {
                throw ManagementSupport.failure("stop", "SA does not exist: " + serviceAssemblyName);
            }
            sa.stop();
            return ManagementSupport.createSuccessMessage("stop service assembly successfully", serviceAssemblyName);
        }
        catch (Exception e) {
            LOG.info((Object)"Error in stop", (Throwable)e);
            throw e;
        }
    }

    public String shutDown(String serviceAssemblyName) throws Exception {
        try {
            ServiceAssemblyImpl sa = this.deployer.getServiceAssembly(serviceAssemblyName);
            if (sa == null) {
                throw ManagementSupport.failure("shutdown", "SA does not exist: " + serviceAssemblyName);
            }
            sa.shutDown();
            return ManagementSupport.createSuccessMessage("shutdown service assembly successfully", serviceAssemblyName);
        }
        catch (Exception e) {
            LOG.info((Object)"Error in shutdown", (Throwable)e);
            throw e;
        }
    }

    public String getState(String serviceAssemblyName) throws Exception {
        try {
            ServiceAssemblyImpl sa = this.deployer.getServiceAssembly(serviceAssemblyName);
            if (sa == null) {
                throw ManagementSupport.failure("getState", "SA does not exist: " + serviceAssemblyName);
            }
            return sa.getCurrentState();
        }
        catch (Exception e) {
            LOG.info((Object)"Error in getState", (Throwable)e);
            throw e;
        }
    }

    public String[] getDeployedServiceAssembliesForComponent(String componentName) {
        HashSet<String> tmpList = new HashSet<String>();
        for (ServiceAssemblyImpl sa : this.deployer.getServiceAssemblies().values()) {
            for (ServiceUnit su : sa.getServiceUnits()) {
                if (!su.getComponent().getName().equals(componentName)) continue;
                tmpList.add(sa.getName());
            }
        }
        String[] result = new String[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public String[] getDeployedServiceUnitsForComponent(String componentName) {
        HashSet<String> tmpList = new HashSet<String>();
        for (ServiceAssemblyImpl sa : this.deployer.getServiceAssemblies().values()) {
            for (ServiceUnit su : sa.getServiceUnits()) {
                if (!su.getComponent().getName().equals(componentName)) continue;
                tmpList.add(su.getName());
            }
        }
        String[] result = new String[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public String[] getComponentsForDeployedServiceAssembly(String saName) {
        HashSet<String> tmpList = new HashSet<String>();
        ServiceAssemblyImpl sa = this.deployer.getServiceAssembly(saName);
        if (sa != null) {
            for (ServiceUnit su : sa.getServiceUnits()) {
                if (!su.getComponent().getName().equals(saName)) continue;
                tmpList.add(su.getComponent().getName());
            }
        }
        String[] result = new String[tmpList.size()];
        tmpList.toArray(result);
        return result;
    }

    public boolean isDeployedServiceUnit(String componentName, String suName) {
        for (ServiceAssemblyImpl sa : this.deployer.getServiceAssemblies().values()) {
            ServiceUnit[] sus = sa.getServiceUnits();
            if (sus == null) continue;
            for (ServiceUnit su : sus) {
                if (!su.getComponent().getName().equals(componentName) || !su.getName().equals(suName)) continue;
                return true;
            }
        }
        return false;
    }
}

