/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.artifacts;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.SharedLibrary;
import org.apache.servicemix.jbi.deployer.descriptor.DescriptorFactory;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryDesc;
import org.apache.servicemix.nmr.management.Nameable;
import org.osgi.framework.Bundle;

public class SharedLibraryImpl
implements SharedLibrary,
Nameable {
    protected final Log LOGGER = LogFactory.getLog(this.getClass());
    private SharedLibraryDesc library;
    private Bundle bundle;
    private ClassLoader classLoader;
    private List<Component> components;

    public SharedLibraryImpl(Bundle bundle, SharedLibraryDesc library, ClassLoader classLoader) {
        this.bundle = bundle;
        this.library = library;
        this.classLoader = classLoader;
        this.components = new ArrayList<Component>();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getName() {
        return this.library.getIdentification().getName();
    }

    public String getDescription() {
        return this.library.getIdentification().getDescription();
    }

    public String getDescriptor() {
        URL url = this.bundle.getResource("META-INF/jbi.xml");
        return DescriptorFactory.getDescriptorAsText(url);
    }

    public String getVersion() {
        return this.library.getVersion();
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            // empty if block
        }
        return this.classLoader;
    }

    public Component[] getComponents() {
        return this.components.toArray(new Component[this.components.size()]);
    }

    public void addComponent(Component component) {
        this.components.add(component);
    }

    public void removeComponent(Component component) {
        this.components.remove(component);
    }

    public String getParent() {
        return null;
    }

    public String getMainType() {
        return "SharedLibrary";
    }

    public String getSubType() {
        return null;
    }

    public Class getPrimaryInterface() {
        return SharedLibrary.class;
    }
}

