/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.artifacts;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.event.EndpointListener;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyReferencesListener
implements EndpointListener,
ExchangeListener {
    private final ThreadLocal<ServiceAssembly> assembly = new ThreadLocal();
    private final ConcurrentMap<InternalEndpoint, ServiceAssembly> endpoints = new ConcurrentHashMap<InternalEndpoint, ServiceAssembly>();
    private final ConcurrentMap<ServiceAssembly, AtomicInteger> references = new ConcurrentHashMap<ServiceAssembly, AtomicInteger>();
    private final ConcurrentMap<ServiceAssembly, Object> locks = new ConcurrentHashMap<ServiceAssembly, Object>();
    private final ConcurrentMap<InternalExchange, ServiceAssembly> pending = new ConcurrentHashMap<InternalExchange, ServiceAssembly>();

    public void setAssembly(ServiceAssembly assembly) {
        this.assembly.set(assembly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(ServiceAssembly assembly) {
        for (Map.Entry entry : this.endpoints.entrySet()) {
            if (entry.getValue() != assembly) continue;
            this.endpoints.remove(entry.getKey());
        }
        AtomicInteger count = (AtomicInteger)this.references.remove(assembly);
        if (count != null) {
            Object lock;
            count.set(0);
            Object v = lock = this.locks.remove(assembly);
            synchronized (v) {
                lock.notifyAll();
            }
        }
    }

    public void endpointRegistered(InternalEndpoint endpoint) {
        ServiceAssembly assembly = this.assembly.get();
        if (assembly != null) {
            this.endpoints.put(endpoint, assembly);
            if (this.references.get(assembly) == null) {
                this.references.put(assembly, new AtomicInteger());
            }
            if (this.locks.get(assembly) == null) {
                this.locks.put(assembly, new Object());
            }
        }
    }

    public void endpointUnregistered(InternalEndpoint endpoint) {
        this.endpoints.remove(endpoint);
    }

    public void exchangeSent(Exchange exchange) {
        if (exchange.getStatus() == Status.Active && exchange.getRole() == Role.Consumer && exchange.getOut(false) == null && exchange.getFault(false) == null && exchange instanceof InternalExchange) {
            InternalExchange ie = (InternalExchange)exchange;
            this.reference(ie.getSource());
            if (this.isSync(exchange)) {
                this.pending(ie);
            }
        }
    }

    private boolean isSync(Exchange exchange) {
        return exchange.getProperty("javax.jbi.messaging.sendSync") != null && (Boolean)exchange.getProperty("javax.jbi.messaging.sendSync", Boolean.class) != false;
    }

    private void pending(InternalExchange exchange) {
        ServiceAssembly assembly = (ServiceAssembly)this.endpoints.get(exchange.getSource());
        if (assembly != null) {
            this.pending.put(exchange, assembly);
        }
    }

    public void exchangeDelivered(Exchange exchange) {
        if (exchange.getStatus() != Status.Active) {
            if (exchange instanceof InternalExchange) {
                InternalExchange ie = (InternalExchange)exchange;
                this.unreference(ie.getSource());
                this.unreference(ie.getDestination());
                this.pending.remove(exchange);
            }
        } else if (exchange.getStatus() == Status.Active && exchange.getRole() == Role.Provider && exchange.getOut(false) == null && exchange.getFault(false) == null && exchange instanceof InternalExchange) {
            InternalExchange ie = (InternalExchange)exchange;
            this.reference(ie.getDestination());
        }
    }

    public void exchangeFailed(Exchange exchange) {
        if (exchange instanceof InternalExchange) {
            InternalExchange ie = (InternalExchange)exchange;
            this.unreference(ie.getSource());
            this.unreference(ie.getDestination());
            this.pending.remove(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(ServiceAssembly assembly) throws InterruptedException {
        AtomicInteger count;
        if (assembly != null && (count = (AtomicInteger)this.references.get(assembly)) != null && count.get() != 0) {
            Object lock;
            Object v = lock = this.locks.get(assembly);
            synchronized (v) {
                while (count.get() != 0) {
                    lock.wait(Long.MAX_VALUE);
                }
            }
        }
    }

    public void cancelPendingSyncExchanges(ServiceAssembly assembly) {
        if (assembly != null) {
            for (InternalExchange exchange : this.getPending(assembly)) {
                exchange.cancel();
            }
        }
    }

    private void reference(InternalEndpoint endpoint) {
        if (endpoint != null) {
            this.reference((ServiceAssembly)this.endpoints.get(endpoint));
        }
    }

    private void unreference(InternalEndpoint endpoint) {
        if (endpoint != null) {
            this.unreference((ServiceAssembly)this.endpoints.get(endpoint));
        }
    }

    private void reference(ServiceAssembly assembly) {
        AtomicInteger count;
        if (assembly != null && (count = (AtomicInteger)this.references.get(assembly)) != null) {
            count.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unreference(ServiceAssembly assembly) {
        AtomicInteger count;
        if (assembly != null && (count = (AtomicInteger)this.references.get(assembly)) != null && count.decrementAndGet() == 0) {
            Object lock;
            Object v = lock = this.locks.get(assembly);
            synchronized (v) {
                lock.notifyAll();
            }
        }
    }

    protected Set<InternalExchange> getPending(ServiceAssembly assembly) {
        HashSet<InternalExchange> result = new HashSet<InternalExchange>();
        for (InternalExchange exchange : this.pending.keySet()) {
            if (!((ServiceAssembly)this.pending.get(exchange)).equals(assembly)) continue;
            result.add(exchange);
        }
        return result;
    }
}

