/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.examples.nmr.client;

import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class Client
implements InitializingBean,
DisposableBean,
Runnable {
    private final Logger logger = LoggerFactory.getLogger(Client.class);
    private NMR nmr;
    private Thread sendRequestThread;
    private volatile boolean run = true;

    public void afterPropertiesSet() throws Exception {
        this.sendRequestThread = new Thread(this);
        this.sendRequestThread.start();
    }

    public void destroy() throws Exception {
        this.run = false;
        if (this.sendRequestThread != null) {
            this.sendRequestThread.interrupt();
        }
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public NMR getNmr() {
        return this.nmr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Channel client = null;
        try {
            client = this.nmr.createChannel();
            Reference ref = this.nmr.getEndpointRegistry().lookup(ServiceHelper.createMap((String[])new String[]{"NAME", "EchoEndpoint"}));
            while (this.run) {
                try {
                    Exchange e = client.createExchange(Pattern.InOut);
                    e.setTarget(ref);
                    e.getIn().setBody((Object)"Hello");
                    client.sendSync(e);
                    this.logger.info("Response from Endpoint {}", e.getOut().getBody());
                    e.setStatus(Status.Done);
                    client.send(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error(e.getMessage());
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }
}

