/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.examples.interceptors.exchange;

import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomExchangeListener
implements ExchangeListener {
    private final Logger logger = LoggerFactory.getLogger(CustomExchangeListener.class);

    public void exchangeSent(Exchange exchange) {
        try {
            this.logger.info("Sending exchange: {}", (Object)exchange);
            if (exchange instanceof InternalExchange && exchange.getStatus() == Status.Active && exchange.getRole() == Role.Consumer && exchange.getOut(false) == null && exchange.getFault(false) == null) {
                String id = ((InternalExchange)exchange).getSource().getId();
                this.logger.info("Source endpoint: {}", (Object)id);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Caught exception while processing exchange: {}", (Object)t, (Object)t);
        }
    }

    public void exchangeDelivered(Exchange exchange) {
        try {
            this.logger.info("Receiving exchange: {}", (Object)exchange);
            if (exchange.getStatus() == Status.Active && exchange.getRole() == Role.Provider && exchange.getOut(false) == null && exchange.getFault(false) == null && exchange instanceof InternalExchange) {
                String id = ((InternalExchange)exchange).getDestination().getId();
                this.logger.info("Dest endpoint: {}", (Object)id);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Caught exception while processing exchange: {}", (Object)t, (Object)t);
        }
    }

    public void exchangeFailed(Exchange exchange) {
        this.logger.info("Exchange Failed: {}", (Object)exchange);
    }
}

