/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.examples.drools.spring.osgi;

import java.util.ArrayList;
import org.apache.servicemix.examples.drools.spring.model.Customer;
import org.apache.servicemix.examples.drools.spring.osgi.Utils;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.command.CommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRuleBean {
    protected static final transient Logger logger = LoggerFactory.getLogger(SimpleRuleBean.class);
    private StatelessKieSession ksession;

    public void start() throws Exception {
        for (int i = 0; i < 10; ++i) {
            Customer customer = Utils.customer();
            logger.info("------------------- START ------------------\n KieSession fireAllRules. {}", (Object)customer);
            ArrayList<Command> commands = new ArrayList<Command>();
            commands.add(CommandFactory.newInsert((Object)customer, (String)"customer"));
            commands.add(CommandFactory.newFireAllRules((String)"num-rules-fired"));
            ExecutionResults results = (ExecutionResults)this.ksession.execute((Command)CommandFactory.newBatchExecution(commands));
            int fired = Integer.parseInt(results.getValue("num-rules-fired").toString());
            customer = (Customer)results.getValue("customer");
            logger.info("After rule rules-fired={} {} \n------------------- STOP ---------------------", (Object)fired, (Object)customer);
        }
    }

    public void setKsession(StatelessKieSession ksession) {
        this.ksession = ksession;
    }
}

