/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.examples.drools.simple.osgi;

import org.apache.servicemix.examples.drools.simple.model.Customer;
import org.apache.servicemix.examples.drools.simple.osgi.Utils;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.event.rule.DebugRuleRuntimeEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRuleActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleRuleActivator.class);
    private KieSession ksession;

    public void start(BundleContext context) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieContainer kcont = ks.newKieClasspathContainer(this.getClass().getClassLoader());
        KieBase kbase = kcont.getKieBase("SimpleRuleKBase");
        logger.info("KieSession newKieSession.");
        this.ksession = kbase.newKieSession();
        this.ksession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        this.ksession.addEventListener((RuleRuntimeEventListener)new DebugRuleRuntimeEventListener());
        Customer customer = Utils.customerPoor();
        logger.info("KieSession fireAllRules. {}", (Object)customer);
        FactHandle fh = this.ksession.insert((Object)customer);
        this.ksession.fireAllRules();
        this.ksession.delete(fh);
        logger.info("After rule {}", (Object)customer);
        customer = Utils.customerNormal();
        logger.info("KieSession fireAllRules. {}", (Object)customer);
        fh = this.ksession.insert((Object)customer);
        this.ksession.fireAllRules();
        this.ksession.delete(fh);
        logger.info("After rule {}", (Object)customer);
        customer = Utils.customerVip();
        logger.info("KieSession fireAllRules. {}", (Object)customer);
        fh = this.ksession.insert((Object)customer);
        this.ksession.fireAllRules();
        this.ksession.delete(fh);
        logger.info("After rule {}", (Object)customer);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.ksession != null) {
            this.ksession.dispose();
            logger.debug("KieSession disposed.");
        }
    }
}

