/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.samples.cxf_ws_rm;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.servicemix.examples.cxf.HelloWorld;
import org.apache.servicemix.samples.cxf_ws_rm.MessageLossSimulator;

public final class Client {
    private static final String USER_NAME = System.getProperty("user.name");
    private static final QName SERVICE_NAME = new QName("http://cxf.examples.servicemix.apache.org/", "HelloWorldImplService");
    private static final QName PORT_NAME = new QName("http://cxf.examples.servicemix.apache.org/", "HelloWorldImplPort");

    private Client() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            SpringBusFactory bf = new SpringBusFactory();
            URL busFile = Client.class.getResource("ws_rm.xml");
            Bus bus = bf.createBus(busFile.toString());
            SpringBusFactory.setDefaultBus((Bus)bus);
            bus.getOutInterceptors().add(new MessageLossSimulator());
            Service service = Service.create((URL)Client.class.getResource("/HelloWorld.wsdl"), (QName)SERVICE_NAME);
            String endpointAddress = "http://localhost:8181/cxf/HelloWorld";
            service.addPort(PORT_NAME, "http://schemas.xmlsoap.org/wsdl/soap/http", endpointAddress);
            HelloWorld hw = (HelloWorld)service.getPort(HelloWorld.class);
            String[] names = new String[]{"Anne", "Bill", "Chris", "Daisy"};
            for (int i = 0; i < 4; ++i) {
                System.out.println("Calling HelloWorld service");
                System.out.println(hw.sayHi(names[i]));
            }
            Thread.sleep(60000L);
            bus.shutdown(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }
}

