/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.samples.cxf_ws_rm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.io.AbstractWrappedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.rm.RMContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageLossSimulator
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = Logger.getLogger(MessageLossSimulator.class.getName());
    private int appMessageCount;

    public MessageLossSimulator() {
        super("prepare-send");
        this.addBefore(MessageSenderInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)true);
        RMContextUtils.ensureExposedVersion((AddressingProperties)maps);
        String action = null;
        if (maps != null && null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (RMContextUtils.isRMProtocolMessage(action)) {
            return;
        }
        ++this.appMessageCount;
        if (0 != this.appMessageCount % 2) {
            return;
        }
        InterceptorChain chain = message.getInterceptorChain();
        ListIterator it = chain.getIterator();
        while (it.hasNext()) {
            PhaseInterceptor pi = (PhaseInterceptor)it.next();
            if (!MessageSenderInterceptor.class.getName().equals(pi.getId())) continue;
            chain.remove((Interceptor)pi);
            LOG.fine("Removed MessageSenderInterceptor from interceptor chain.");
            break;
        }
        message.setContent(OutputStream.class, (Object)new WrappedOutputStream(message));
        message.getInterceptorChain().add((Interceptor)new AbstractPhaseInterceptor<Message>("prepare-send-ending"){

            public void handleMessage(Message message) throws Fault {
                try {
                    ((OutputStream)message.getContent(OutputStream.class)).close();
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
            }
        });
    }

    private class DummyOutputStream
    extends OutputStream {
        private DummyOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }

    private class WrappedOutputStream
    extends AbstractWrappedOutputStream {
        private Message outMessage;

        public WrappedOutputStream(Message m) {
            this.outMessage = m;
        }

        protected void onFirstWrite() throws IOException {
            if (LOG.isLoggable(Level.FINE)) {
                Long nr = RMContextUtils.retrieveRMProperties((Message)this.outMessage, (boolean)true).getSequence().getMessageNumber();
                LOG.fine("Losing message " + nr);
            }
            this.wrappedStream = new DummyOutputStream();
        }
    }
}

