/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.examples.cxf.jaxrs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.servicemix.examples.cxf.jaxrs.Customer;
import org.apache.servicemix.examples.cxf.jaxrs.Order;

@Path(value="/customerservice")
@Api(value="/customerservice", description="Operations about customerservice")
public class CustomerService {
    long currentId = 123L;
    Map<Long, Customer> customers = new HashMap<Long, Customer>();
    Map<Long, Order> orders = new HashMap<Long, Order>();

    public CustomerService() {
        this.init();
    }

    @GET
    @Path(value="/customers/{id}/")
    @Produces(value={"application/xml"})
    @ApiOperation(value="Find Customer by ID", notes="More notes about this method", response=Customer.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Invalid ID supplied"), @ApiResponse(code=204, message="Customer not found")})
    public Customer getCustomer(@ApiParam(value="ID of Customer to fetch", required=true) @PathParam(value="id") String id) {
        System.out.println("----invoking getCustomer, Customer id is: " + id);
        long idNumber = Long.parseLong(id);
        Customer c = this.customers.get(idNumber);
        return c;
    }

    @PUT
    @Path(value="/customers/")
    @ApiOperation(value="Update an existing Customer")
    @ApiResponses(value={@ApiResponse(code=500, message="Invalid ID supplied"), @ApiResponse(code=204, message="Customer not found")})
    public Response updateCustomer(@ApiParam(value="Customer object that needs to be updated", required=true) Customer customer) {
        Response r;
        System.out.println("----invoking updateCustomer, Customer name is: " + customer.getName());
        Customer c = this.customers.get(customer.getId());
        if (c != null) {
            this.customers.put(customer.getId(), customer);
            r = Response.ok().build();
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @POST
    @Path(value="/customers/")
    @ApiOperation(value="Add a new Customer")
    @ApiResponses(value={@ApiResponse(code=500, message="Invalid ID supplied")})
    public Response addCustomer(@ApiParam(value="Customer object that needs to be updated", required=true) Customer customer) {
        System.out.println("----invoking addCustomer, Customer name is: " + customer.getName());
        customer.setId(++this.currentId);
        this.customers.put(customer.getId(), customer);
        return Response.ok().type("application/xml").entity((Object)customer).build();
    }

    @DELETE
    @Path(value="/customers/{id}/")
    @ApiOperation(value="Delete Customer")
    @ApiResponses(value={@ApiResponse(code=500, message="Invalid ID supplied"), @ApiResponse(code=204, message="Customer not found")})
    public Response deleteCustomer(@ApiParam(value="ID of Customer to delete", required=true) @PathParam(value="id") String id) {
        Response r;
        System.out.println("----invoking deleteCustomer, Customer id is: " + id);
        long idNumber = Long.parseLong(id);
        Customer c = this.customers.get(idNumber);
        if (c != null) {
            r = Response.ok().build();
            this.customers.remove(idNumber);
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @Path(value="/orders/{orderId}/")
    public Order getOrder(@PathParam(value="orderId") String orderId) {
        System.out.println("----invoking getOrder, Order id is: " + orderId);
        long idNumber = Long.parseLong(orderId);
        Order c = this.orders.get(idNumber);
        return c;
    }

    final void init() {
        Customer c = new Customer();
        c.setName("John");
        c.setId(123L);
        this.customers.put(c.getId(), c);
        Order o = new Order();
        o.setDescription("order 223");
        o.setId(223L);
        this.orders.put(o.getId(), o);
    }
}

