/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.examples.cxfcamel;

import java.util.logging.Logger;
import javax.xml.transform.Source;
import org.apache.camel.converter.jaxp.StringSource;
import org.apache.camel.converter.jaxp.XmlConverter;

public class MyTransform {
    private static final transient Logger LOG = Logger.getLogger(MyTransform.class.getName());
    private boolean verbose = true;
    private String value;

    public Object transform(Object body) {
        if (this.verbose) {
            System.out.println(">>>> " + this.value);
        }
        LOG.info(">>>> " + this.value);
        return new StringSource(this.value);
    }

    public void display(Source body) throws Exception {
        String str = new XmlConverter().toString(body);
        if (this.verbose) {
            System.out.println("<<<< " + str);
        }
        LOG.info("<<<< " + str);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

