/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.examples.camel.soap;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Body;
import org.apache.camel.Exchange;
import org.apache.servicemix.examples.camel.soap.model.Person;
import org.apache.servicemix.examples.camel.soap.model.PersonException;

public class ServiceHandler {
    public static final String ERR_PERSON_X_NOT_FOUND = "Person %s not found";
    Map<Integer, Person> persons = new HashMap<Integer, Person>();

    public void init() {
        Person person = new Person(0, "test", 100);
        this.persons.put(person.getId(), person);
    }

    public void getPerson(@Body String id, Exchange exchange) {
        Person result = this.persons.get(Integer.parseInt(id));
        this.checkResult(id, exchange, result);
    }

    public Person putPerson(Person person) {
        this.persons.put(person.getId(), person);
        return person;
    }

    public void deletePerson(@Body String id, Exchange exchange) {
        Person result = this.persons.remove(Integer.parseInt(id));
        this.checkResult(id, exchange, result);
    }

    private void checkResult(String id, Exchange exchange, Person result) {
        if (result == null) {
            exchange.getOut().setFault(true);
            exchange.getOut().setBody((Object)new PersonException(String.format(ERR_PERSON_X_NOT_FOUND, id), id));
        } else {
            exchange.getOut().setBody((Object)result);
        }
    }
}

