/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.examples.camel.rest;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.servicemix.examples.camel.rest.model.Person;

public class ServiceHandler {
    private Map<Integer, Person> persons = new HashMap<Integer, Person>();

    public void init() {
        this.add(new Person(0, "Test Person", 100));
    }

    private Response add(Person person) {
        this.persons.put(person.getId(), person);
        return Response.created((URI)URI.create("/personservice/person/get/" + person.getId())).build();
    }

    private Person get(int id) {
        Person person = this.persons.get(id);
        if (person == null) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            builder.entity((Object)("Person with ID " + id + " not found."));
            throw new WebApplicationException(builder.build());
        }
        return person;
    }

    private void delete(int id) {
        if (this.persons.remove(id) == null) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            builder.entity((Object)("Person with ID " + id + " not found."));
            throw new WebApplicationException(builder.build());
        }
    }

    public Person getPerson(String id) {
        return this.get(Integer.parseInt(id));
    }

    public Response putPerson(Person person) {
        return this.add(person);
    }

    public void deletePerson(int id) {
        this.delete(id);
    }
}

