/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.examples.camel.rest.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.cxf.helpers.IOUtils;
import org.apache.servicemix.examples.camel.rest.model.Person;

public class Client {
    private static final String PERSON_SERVICE_URL = "http://localhost:8989/rest/personservice/";

    public static void main(String[] args) {
        Client client = new Client();
        try {
            client.postPerson(new Person(1, "John Smith", 21));
            client.getPerson(1);
            client.deletePerson(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void postPerson(Person person) throws Exception {
        System.out.println("\n### POST PERSON -> ");
        HttpURLConnection connection = this.connect("http://localhost:8989/rest/personservice/person/post/");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/xml");
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Person.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal((Object)person, (OutputStream)System.out);
        jaxbMarshaller.marshal((Object)person, connection.getOutputStream());
        System.out.println("\n### POST PERSON RESPONSE");
        System.out.println("Status: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        System.out.println("Location: " + connection.getHeaderField("Location"));
    }

    public void getPerson(int id) throws Exception {
        String url = "http://localhost:8989/rest/personservice/person/get/" + id;
        System.out.println("\n### GET PERSON WITH ID " + id + " FROM URL " + url);
        HttpURLConnection connection = this.connect(url);
        connection.setDoInput(true);
        InputStream stream = connection.getResponseCode() / 100 == 2 ? connection.getInputStream() : connection.getErrorStream();
        System.out.println("Status: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        System.out.println(IOUtils.toString((InputStream)stream));
    }

    public void deletePerson(int id) throws Exception {
        String url = "http://localhost:8989/rest/personservice/person/delete/" + id;
        System.out.println("\n### DELETE PERSON WITH ID " + id + " FROM URL " + url);
        HttpURLConnection connection = this.connect(url);
        connection.setRequestMethod("DELETE");
        connection.setDoInput(true);
        System.out.println("Status: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() / 100 != 2) {
            System.out.println(IOUtils.toString((InputStream)connection.getErrorStream()));
        }
    }

    private HttpURLConnection connect(String url) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        return connection;
    }
}

