/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.DestinationAlreadyExistsException;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.AbstractSubscription;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFactory;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.QueueBrowserSubscription;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.usage.SystemUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegion
implements Region {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRegion.class);
    protected final Map<ActiveMQDestination, Destination> destinations = new ConcurrentHashMap<ActiveMQDestination, Destination>();
    protected final DestinationMap destinationMap = new DestinationMap();
    protected final Map<ConsumerId, Subscription> subscriptions = new ConcurrentHashMap<ConsumerId, Subscription>();
    protected final SystemUsage usageManager;
    protected final DestinationFactory destinationFactory;
    protected final DestinationStatistics destinationStatistics;
    protected final RegionBroker broker;
    protected boolean autoCreateDestinations = true;
    protected final TaskRunnerFactory taskRunnerFactory;
    protected final Object destinationsMutex = new Object();
    protected final Map<ConsumerId, Object> consumerChangeMutexMap = new HashMap<ConsumerId, Object>();
    protected boolean started;

    public AbstractRegion(RegionBroker broker, DestinationStatistics destinationStatistics, SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        if (broker == null) {
            throw new IllegalArgumentException("null broker");
        }
        this.broker = broker;
        this.destinationStatistics = destinationStatistics;
        this.usageManager = memoryManager;
        this.taskRunnerFactory = taskRunnerFactory;
        if (broker == null) {
            throw new IllegalArgumentException("null destinationFactory");
        }
        this.destinationFactory = destinationFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws Exception {
        this.started = true;
        Set<ActiveMQDestination> inactiveDests = this.getInactiveDestinations();
        for (ActiveMQDestination dest : inactiveDests) {
            ConnectionContext context = new ConnectionContext();
            context.setBroker(this.broker.getBrokerService().getBroker());
            context.setSecurityContext(SecurityContext.BROKER_SECURITY_CONTEXT);
            context.getBroker().addDestination(context, dest, false);
        }
        Object object = this.destinationsMutex;
        synchronized (object) {
            for (Destination dest : this.destinations.values()) {
                dest.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        this.started = false;
        Object object = this.destinationsMutex;
        synchronized (object) {
            for (Destination dest : this.destinations.values()) {
                dest.stop();
            }
        }
        this.destinations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean createIfTemporary) throws Exception {
        LOG.debug(this.broker.getBrokerName() + " adding destination: " + destination);
        Object object = this.destinationsMutex;
        synchronized (object) {
            Destination dest = this.destinations.get(destination);
            if (dest == null) {
                if (!destination.isTemporary() || createIfTemporary) {
                    dest = this.createDestination(context, destination);
                    DestinationInterceptor destinationInterceptor = this.broker.getDestinationInterceptor();
                    if (destinationInterceptor != null) {
                        dest = destinationInterceptor.intercept(dest);
                    }
                    dest.start();
                    this.destinations.put(destination, dest);
                    this.destinationMap.put(destination, dest);
                    this.addSubscriptionsForDestination(context, dest);
                }
                if (dest == null) {
                    throw new JMSException("The destination " + destination + " does not exist.");
                }
            }
            return dest;
        }
    }

    public Map<ConsumerId, Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    protected List<Subscription> addSubscriptionsForDestination(ConnectionContext context, Destination dest) throws Exception {
        ArrayList<Subscription> rc = new ArrayList<Subscription>();
        for (Subscription sub : this.subscriptions.values()) {
            if (!sub.matches(dest.getActiveMQDestination())) continue;
            dest.addSubscription(context, sub);
            rc.add(sub);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        if (timeout == 0L) {
            for (Subscription sub : this.subscriptions.values()) {
                if (!sub.matches(destination)) continue;
                throw new JMSException("Destination still has an active subscription: " + destination);
            }
        }
        if (timeout > 0L) {
            // empty if block
        }
        LOG.debug("Removing destination: " + destination);
        Object object = this.destinationsMutex;
        synchronized (object) {
            Destination dest = this.destinations.remove(destination);
            if (dest != null) {
                for (Subscription sub : this.subscriptions.values()) {
                    if (!sub.matches(destination)) continue;
                    dest.removeSubscription(context, sub, 0L);
                }
                this.destinationMap.removeAll(destination);
                this.dispose(context, dest);
                DestinationInterceptor destinationInterceptor = this.broker.getDestinationInterceptor();
                if (destinationInterceptor != null) {
                    destinationInterceptor.remove(dest);
                }
            } else {
                LOG.debug("Destination doesn't exist: " + dest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Destination> getDestinations(ActiveMQDestination destination) {
        Object object = this.destinationsMutex;
        synchronized (object) {
            return this.destinationMap.get(destination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ActiveMQDestination, Destination> getDestinationMap() {
        Object object = this.destinationsMutex;
        synchronized (object) {
            return new HashMap<ActiveMQDestination, Destination>(this.destinations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Object addGuard;
        LOG.debug(this.broker.getBrokerName() + " adding consumer: " + info.getConsumerId() + " for destination: " + info.getDestination());
        ActiveMQDestination destination = info.getDestination();
        if (destination != null && !destination.isPattern() && !destination.isComposite()) {
            this.lookup(context, destination, true);
        }
        Object object = this.consumerChangeMutexMap;
        synchronized (object) {
            addGuard = this.consumerChangeMutexMap.get(info.getConsumerId());
            if (addGuard == null) {
                addGuard = new Object();
                this.consumerChangeMutexMap.put(info.getConsumerId(), addGuard);
            }
        }
        object = addGuard;
        synchronized (object) {
            Subscription o = this.subscriptions.get(info.getConsumerId());
            if (o != null) {
                LOG.warn("A duplicate subscription was detected. Clients may be misbehaving. Later warnings you may see about subscription removal are a consequence of this.");
                return o;
            }
            DestinationFilter.parseFilter(info.getDestination());
            Subscription sub = this.createSubscription(context, info);
            this.subscriptions.put(info.getConsumerId(), sub);
            ArrayList<Destination> addList = new ArrayList<Destination>();
            Object object2 = this.destinationsMutex;
            synchronized (object2) {
                for (Destination dest : this.destinationMap.get(info.getDestination())) {
                    addList.add(dest);
                }
            }
            for (Destination dest : addList) {
                dest.addSubscription(context, sub);
            }
            if (info.isBrowser()) {
                ((QueueBrowserSubscription)sub).destinationsAdded();
            }
            return sub;
        }
    }

    public Set getDurableDestinations() {
        return this.destinationFactory.getDestinations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ActiveMQDestination> getInactiveDestinations() {
        Set<ActiveMQDestination> inactiveDests = this.destinationFactory.getDestinations();
        Object object = this.destinationsMutex;
        synchronized (object) {
            inactiveDests.removeAll(this.destinations.keySet());
        }
        return inactiveDests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        LOG.debug(this.broker.getBrokerName() + " removing consumer: " + info.getConsumerId() + " for destination: " + info.getDestination());
        Subscription sub = this.subscriptions.remove(info.getConsumerId());
        if (sub != null) {
            ArrayList<Destination> removeList = new ArrayList<Destination>();
            Object object = this.destinationsMutex;
            synchronized (object) {
                for (Destination dest : this.destinationMap.get(info.getDestination())) {
                    removeList.add(dest);
                }
            }
            for (Destination dest : removeList) {
                dest.removeSubscription(context, sub, info.getLastDeliveredSequenceId());
            }
            this.destroySubscription(sub);
        }
        Map<ConsumerId, Object> map = this.consumerChangeMutexMap;
        synchronized (map) {
            this.consumerChangeMutexMap.remove(info.getConsumerId());
        }
    }

    protected void destroySubscription(Subscription sub) {
        sub.destroy();
    }

    @Override
    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        throw new JMSException("Invalid operation.");
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        ConnectionContext context = producerExchange.getConnectionContext();
        if (producerExchange.isMutable() || producerExchange.getRegionDestination() == null) {
            Destination regionDestination = this.lookup(context, messageSend.getDestination(), false);
            producerExchange.setRegionDestination(regionDestination);
        }
        producerExchange.getRegionDestination().send(producerExchange, messageSend);
    }

    @Override
    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        Subscription sub = consumerExchange.getSubscription();
        if (sub == null) {
            sub = this.subscriptions.get(ack.getConsumerId());
            if (sub == null) {
                if (!consumerExchange.getConnectionContext().isInRecoveryMode()) {
                    LOG.warn("Ack for non existent subscription, ack:" + ack);
                    throw new IllegalArgumentException("The subscription does not exist: " + ack.getConsumerId());
                }
                LOG.debug("Ack for non existent subscription in recovery, ack:" + ack);
                return;
            }
            consumerExchange.setSubscription(sub);
        }
        sub.acknowledge(consumerExchange.getConnectionContext(), ack);
    }

    @Override
    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        Subscription sub = this.subscriptions.get(pull.getConsumerId());
        if (sub == null) {
            throw new IllegalArgumentException("The subscription does not exist: " + pull.getConsumerId());
        }
        return sub.pullMessage(context, pull);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination lookup(ConnectionContext context, ActiveMQDestination destination, boolean createTemporary) throws Exception {
        Destination dest = null;
        Object object = this.destinationsMutex;
        synchronized (object) {
            dest = this.destinations.get(destination);
        }
        if (dest == null) {
            if (this.isAutoCreateDestinations()) {
                try {
                    context.getBroker().addDestination(context, destination, createTemporary);
                    dest = this.addDestination(context, destination, false);
                }
                catch (DestinationAlreadyExistsException e) {
                    // empty catch block
                }
                object = this.destinationsMutex;
                synchronized (object) {
                    dest = this.destinations.get(destination);
                }
            }
            if (dest == null) {
                throw new JMSException("The destination " + destination + " does not exist.");
            }
        }
        return dest;
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        Subscription sub = this.subscriptions.get(messageDispatchNotification.getConsumerId());
        if (sub == null) {
            throw new JMSException("Slave broker out of sync with master - Subscription: " + messageDispatchNotification.getConsumerId() + " on " + messageDispatchNotification.getDestination() + " does not exist for dispatch of message: " + messageDispatchNotification.getMessageId());
        }
        sub.processMessageDispatchNotification(messageDispatchNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDispatchNotificationViaDestination(MessageDispatchNotification messageDispatchNotification) throws Exception {
        Destination dest = null;
        Object object = this.destinationsMutex;
        synchronized (object) {
            dest = this.destinations.get(messageDispatchNotification.getDestination());
        }
        if (dest == null) {
            throw new JMSException("Slave broker out of sync with master - Destination: " + messageDispatchNotification.getDestination() + " does not exist for consumer " + messageDispatchNotification.getConsumerId() + " with message: " + messageDispatchNotification.getMessageId());
        }
        dest.processDispatchNotification(messageDispatchNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gc() {
        for (Subscription sub : this.subscriptions.values()) {
            sub.gc();
        }
        Object object = this.destinationsMutex;
        synchronized (object) {
            for (Destination dest : this.destinations.values()) {
                dest.gc();
            }
        }
    }

    protected abstract Subscription createSubscription(ConnectionContext var1, ConsumerInfo var2) throws Exception;

    protected Destination createDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        return this.destinationFactory.createDestination(context, destination, this.destinationStatistics);
    }

    public boolean isAutoCreateDestinations() {
        return this.autoCreateDestinations;
    }

    public void setAutoCreateDestinations(boolean autoCreateDestinations) {
        this.autoCreateDestinations = autoCreateDestinations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        Object object = this.destinationsMutex;
        synchronized (object) {
            for (Destination dest : this.destinationMap.get(info.getDestination())) {
                dest.addProducer(context, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        Object object = this.destinationsMutex;
        synchronized (object) {
            for (Destination dest : this.destinationMap.get(info.getDestination())) {
                dest.removeProducer(context, info);
            }
        }
    }

    protected void dispose(ConnectionContext context, Destination dest) throws Exception {
        dest.dispose(context);
        dest.stop();
        this.destinationFactory.removeDestination(dest);
    }

    @Override
    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        Subscription sub = this.subscriptions.get(control.getConsumerId());
        if (sub != null && sub instanceof AbstractSubscription) {
            ((AbstractSubscription)sub).setPrefetchSize(control.getPrefetch());
            if (LOG.isDebugEnabled()) {
                LOG.debug("setting prefetch: " + control.getPrefetch() + ", on subscription: " + control.getConsumerId());
            }
            try {
                this.lookup(consumerExchange.getConnectionContext(), control.getDestination(), false).wakeup();
            }
            catch (Exception e) {
                LOG.warn("failed to deliver consumerControl to destination: " + control.getDestination(), (Throwable)e);
            }
        }
    }
}

