/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

public final class Location
implements Comparable<Location> {
    public static final byte MARK_TYPE = -1;
    public static final byte USER_TYPE = 1;
    public static final byte NOT_SET_TYPE = 0;
    public static final int NOT_SET = -1;
    private int dataFileId = -1;
    private int offset = -1;
    private int size = -1;
    private byte type = 0;
    private CountDownLatch latch;

    public Location() {
    }

    Location(Location item) {
        this.dataFileId = item.dataFileId;
        this.offset = item.offset;
        this.size = item.size;
        this.type = item.type;
    }

    boolean isValid() {
        return this.dataFileId != -1;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getPaylodSize() {
        return this.size - 32;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getDataFileId() {
        return this.dataFileId;
    }

    public void setDataFileId(int file) {
        this.dataFileId = file;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String toString() {
        String result = "offset = " + this.offset + ", file = " + this.dataFileId + ", size = " + this.size + ", type = " + this.type;
        return result;
    }

    public void writeExternal(DataOutput dos) throws IOException {
        dos.writeInt(this.dataFileId);
        dos.writeInt(this.offset);
        dos.writeInt(this.size);
        dos.writeByte(this.type);
    }

    public void readExternal(DataInput dis) throws IOException {
        this.dataFileId = dis.readInt();
        this.offset = dis.readInt();
        this.size = dis.readInt();
        this.type = dis.readByte();
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    @Override
    public int compareTo(Location o) {
        Location l = o;
        if (this.dataFileId == l.dataFileId) {
            int rc = this.offset - l.offset;
            return rc;
        }
        return this.dataFileId - l.dataFileId;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Location) {
            result = this.compareTo((Location)o) == 0;
        }
        return result;
    }

    public int hashCode() {
        return this.dataFileId ^ this.offset;
    }
}

