/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.examples.activiti;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Body;
import org.apache.camel.Expression;
import org.apache.camel.Handler;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.Simple;
import org.apache.camel.model.RouteDefinition;

public class ActivitiRouteBuilder
extends RouteBuilder {
    private final Helper helper = new Helper();

    public void configure() throws Exception {
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("file:var/activiti-camel/order").setBody((Expression)this.bean(this.helper))).setProperty("PROCESS_KEY_PROPERTY", (Expression)this.simple("file:name"))).to("activiti:OrderProcess")).log("Process to handle incoming order file has been started (process instance id ${body})");
        ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("file:var/activiti-camel/delivery").log("Notifying process about delivery for order ${file:name}")).setBody((Expression)this.bean(this.helper))).setProperty("PROCESS_KEY_PROPERTY", (Expression)this.simple("file:name"))).to("activiti:OrderProcess:receiveDelivery");
        ((RouteDefinition)this.from("activiti:OrderProcess:processOrder?copyVariablesToProperties=true").log("Processing order ${property.orderid} created on ${property.timestamp}")).log("  original message: ${property.message}");
        ((RouteDefinition)this.from("activiti:OrderProcess:processDelivery?copyVariablesToProperties=true").log("Processing delivery for order ${property.orderid} created on ${property.timestamp}")).log("  original message: ${property.message}");
    }

    public static final class Helper {
        @Handler
        public Map getProcessVariables(@Body String body, @Header(value="CamelFileName") String filename, @Simple(value="${date:now:yyyy-MM-dd kk:mm:ss}") String timestamp) {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("message", body);
            variables.put("orderid", filename);
            variables.put("timestamp", timestamp);
            return variables;
        }
    }
}

