/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr.ws.rm;

import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.CamelTestSupport;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.GreeterService;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.servicemix.camel.nmr.ServiceMixComponent;
import org.apache.servicemix.camel.nmr.ws.policy.ConnectionHelper;
import org.apache.servicemix.camel.nmr.ws.rm.GreeterImpl;
import org.apache.servicemix.camel.nmr.ws.rm.TwowayThread;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.core.ServiceMix;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class WSRMTest
extends CamelTestSupport {
    private static final Logger LOG = LogUtils.getL7dLogger(WSRMTest.class);
    protected static final String SERVICE_ADDRESS = "local://smx/hello_world";
    protected AbstractXmlApplicationContext applicationContext;
    private ServerImpl server;
    private CamelContext camelContext;
    private ServiceMixComponent smxComponent;
    private NMR nmr;
    private Bus bus;

    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        super.setUp();
        this.startService();
    }

    protected void startService() {
        GreeterImpl implementor = new GreeterImpl();
        Endpoint.publish((String)SERVICE_ADDRESS, (Object)implementor);
    }

    protected void tearDown() throws Exception {
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
        if (this.server != null) {
            this.server.stop();
        }
        super.tearDown();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("cxf:bean:routerEndpoint").to("smx:testEndpoint");
                this.from("smx:testEndpoint").to("cxf:bean:serviceEndpoint");
            }
        };
    }

    protected CamelContext createCamelContext() throws Exception {
        this.camelContext = SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext);
        this.smxComponent = new ServiceMixComponent();
        this.nmr = new ServiceMix();
        ((ServiceMix)this.nmr).init();
        this.smxComponent.setNmr(this.nmr);
        this.camelContext.addComponent("smx", (Component)this.smxComponent);
        return this.camelContext;
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/servicemix/camel/ws/rm/server.xml");
    }

    public void testDecoupled() throws Exception {
        long start;
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus("/org/apache/servicemix/camel/ws/rm/decoupled.xml");
        LoggingInInterceptor in = new LoggingInInterceptor();
        this.bus.getInInterceptors().add(in);
        this.bus.getInFaultInterceptors().add(in);
        LoggingOutInterceptor out = new LoggingOutInterceptor();
        this.bus.getOutInterceptors().add(out);
        this.bus.getOutFaultInterceptors().add(out);
        QName serviceName = new QName("http://cxf.apache.org/greeter_control", "GreeterService");
        URL wsdl = new ClassPathResource("/wsdl/greeter_control.wsdl").getURL();
        GreeterService gs = new GreeterService(wsdl, serviceName);
        Greeter greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        ConnectionHelper.setKeepAliveConnection(greeter, true);
        TwowayThread t = new TwowayThread(greeter);
        t.start();
        for (long wait = 3000L; wait > 0L; wait -= System.currentTimeMillis() - start) {
            start = System.currentTimeMillis();
            try {
                Thread.sleep(wait);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        greeter.greetMeOneWay("oneway");
        t.join();
        WSRMTest.assertEquals((String)"Unexpected response to twoway request", (String)"oneway", (String)t.getResponse());
    }
}

