/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr.ws.policy;

import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.CamelTestSupport;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.greeter_control.BasicGreeterService;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.PingMeFault;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.servicemix.camel.nmr.ServiceMixComponent;
import org.apache.servicemix.camel.nmr.ws.policy.ConnectionHelper;
import org.apache.servicemix.camel.nmr.ws.policy.GreeterImpl;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.core.ServiceMix;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class WSPolicyTest
extends CamelTestSupport {
    private static final Logger LOG = LogUtils.getL7dLogger(WSPolicyTest.class);
    protected static final String SERVICE_ADDRESS = "local://smx/hello_world";
    protected AbstractXmlApplicationContext applicationContext;
    private ServerImpl server;
    private CamelContext camelContext;
    private ServiceMixComponent smxComponent;
    private NMR nmr;
    private Bus bus;

    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        super.setUp();
        this.startService();
    }

    protected void startService() throws Exception {
        GreeterImpl implementor = new GreeterImpl();
        Endpoint.publish((String)SERVICE_ADDRESS, (Object)((Object)implementor));
    }

    protected void tearDown() throws Exception {
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
        if (this.server != null) {
            this.server.stop();
        }
        super.tearDown();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                this.from("cxf:bean:routerEndpoint").to("smx:testEndpoint");
                this.from("smx:testEndpoint").to("cxf:bean:serviceEndpoint");
            }
        };
    }

    protected CamelContext createCamelContext() throws Exception {
        this.camelContext = SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext);
        this.smxComponent = new ServiceMixComponent();
        this.nmr = new ServiceMix();
        ((ServiceMix)this.nmr).init();
        this.smxComponent.setNmr(this.nmr);
        this.camelContext.addComponent("smx", (Component)this.smxComponent);
        return this.camelContext;
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/servicemix/camel/ws/policy/server.xml");
    }

    public void testUsingAddressing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus("/org/apache/servicemix/camel/ws/policy/addr.xml");
        LoggingInInterceptor in = new LoggingInInterceptor();
        this.bus.getInInterceptors().add(in);
        this.bus.getInFaultInterceptors().add(in);
        LoggingOutInterceptor out = new LoggingOutInterceptor();
        this.bus.getOutInterceptors().add(out);
        this.bus.getOutFaultInterceptors().add(out);
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/greeter_control.wsdl");
        QName serviceName = new QName("http://cxf.apache.org/greeter_control", "BasicGreeterService");
        BasicGreeterService gs = new BasicGreeterService(wsdl, serviceName);
        Greeter greeter = gs.getGreeterPort();
        LOG.info("Created greeter client.");
        if ("HP-UX".equals(System.getProperty("os.name"))) {
            ConnectionHelper.setKeepAliveConnection(greeter, true);
        }
        ((ClientImpl)ClientProxy.getClient((Object)greeter)).setSynchronousTimeout(30000);
        greeter.greetMeOneWay("CXF");
        WSPolicyTest.assertEquals((String)"CXF", (String)greeter.greetMe("cxf"));
        try {
            greeter.pingMe();
        }
        catch (PingMeFault ex) {
            WSPolicyTest.fail((String)"First invocation should have succeeded.");
        }
        try {
            greeter.pingMe();
            WSPolicyTest.fail((String)"Expected PingMeFault not thrown.");
        }
        catch (PingMeFault ex) {
            WSPolicyTest.assertEquals((int)2, (int)ex.getFaultInfo().getMajor());
            WSPolicyTest.assertEquals((int)1, (int)ex.getFaultInfo().getMinor());
        }
    }
}

