/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr.ws.addressing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.impl.AddressingPropertiesImpl;
import org.apache.servicemix.camel.nmr.ws.addressing.GreeterImpl;
import org.apache.servicemix.camel.nmr.ws.addressing.VerificationCache;
import org.apache.servicemix.camel.nmr.ws.addressing.WSAddressingTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAPVerifier
extends AbstractPhaseInterceptor<Message> {
    VerificationCache verificationCache = new GreeterImpl();
    List<String> expectedExposedAs = new ArrayList<String>();
    private Map<String, Object> mapProperties = new HashMap<String, Object>();

    public MAPVerifier() {
        super("post-logical");
        this.mapProperties.put("inbound", "javax.xml.ws.addressing.context.inbound");
        this.mapProperties.put("outbound", "javax.xml.ws.addressing.context.outbound");
    }

    public void handleMessage(Message message) {
        this.verify(message);
    }

    public void handleFault(Message message) {
        this.verify(message);
    }

    private void verify(Message message) {
        boolean isOutbound = ContextUtils.isOutbound((Message)message);
        String mapProperty = (String)this.mapProperties.get(isOutbound ? "outbound" : "inbound");
        AddressingPropertiesImpl maps = (AddressingPropertiesImpl)message.get((Object)mapProperty);
        if (ContextUtils.isRequestor((Message)message)) {
            if (isOutbound) {
                String exposeAs = this.getExpectedExposeAs(false);
                if (exposeAs != null) {
                    maps.exposeAs(exposeAs);
                }
            } else {
                String expected;
                String exposeAs = this.getExpectedExposeAs(true);
                String string = expected = exposeAs != null ? exposeAs : "http://www.w3.org/2005/08/addressing";
                if (maps.getNamespaceURI() != expected) {
                    this.verificationCache.put("Incoming version mismatch expected: " + expected + " got: " + maps.getNamespaceURI());
                }
                exposeAs = null;
            }
        }
        this.verificationCache.put(WSAddressingTest.verifyMAPs((AddressingProperties)maps, (Object)this));
    }

    private String getExpectedExposeAs(boolean remove) {
        int size = this.expectedExposedAs.size();
        return size == 0 ? null : (remove ? this.expectedExposedAs.remove(size - 1) : this.expectedExposedAs.get(size - 1));
    }

    public void setVerificationCache(VerificationCache cache) {
        this.verificationCache = cache;
    }

    public void addToExpectedExposedAs(String str) {
        this.expectedExposedAs.add(str);
    }
}

