/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr.ws.addressing;

import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.hello_world_soap_http.BadRecordLitFault;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.NoSuchCodeLitFault;
import org.apache.hello_world_soap_http.types.BareDocumentResponse;
import org.apache.hello_world_soap_http.types.ErrorCode;
import org.apache.hello_world_soap_http.types.GreetMeLaterResponse;
import org.apache.hello_world_soap_http.types.GreetMeResponse;
import org.apache.hello_world_soap_http.types.GreetMeSometimeResponse;
import org.apache.hello_world_soap_http.types.NoSuchCodeLit;
import org.apache.hello_world_soap_http.types.SayHiResponse;
import org.apache.hello_world_soap_http.types.TestDocLitFaultResponse;
import org.apache.hello_world_soap_http.types.TestNillableResponse;
import org.apache.servicemix.camel.nmr.ws.addressing.VerificationCache;
import org.apache.servicemix.camel.nmr.ws.addressing.WSAddressingTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="SOAPServiceAddressing", portName="SoapPort", endpointInterface="org.apache.hello_world_soap_http.Greeter", targetNamespace="http://apache.org/hello_world_soap_http", wsdlLocation="org/apache/servicemix/camel/ws/addressing/hello_world.wsdl")
public class GreeterImpl
implements Greeter,
VerificationCache {
    private String verified;
    @Resource
    private WebServiceContext context;

    public String greetMe(String me) {
        System.out.println("\n\n*** GreetMe called with: " + me + "***\n\n");
        this.verifyMAPs();
        return "Hello " + me;
    }

    public String greetMeLater(long delay) {
        System.out.println("\n\n*** GreetMeLater called with: " + delay + "***\n\n");
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.verifyMAPs();
        return "Hello, finally";
    }

    public void greetMeOneWay(String requestType) {
        System.out.println("\n\n*** GreetMeOneWay called with: " + requestType + "***\n\n");
        this.verifyMAPs();
    }

    public String sayHi() {
        this.verifyMAPs();
        return "sayHi:Bonjour";
    }

    public void testDocLitFault(String faultType) throws BadRecordLitFault, NoSuchCodeLitFault {
        this.verifyMAPs();
        if (faultType.equals(BadRecordLitFault.class.getSimpleName())) {
            throw new BadRecordLitFault("TestBadRecordLit", "BadRecordLitFault");
        }
        if (faultType.equals(NoSuchCodeLitFault.class.getSimpleName())) {
            ErrorCode ec = new ErrorCode();
            ec.setMajor((short)1);
            ec.setMinor((short)1);
            NoSuchCodeLit nscl = new NoSuchCodeLit();
            nscl.setCode(ec);
            throw new NoSuchCodeLitFault("TestNoSuchCodeLit", nscl);
        }
    }

    public BareDocumentResponse testDocLitBare(String in) {
        BareDocumentResponse res = new BareDocumentResponse();
        res.setCompany("Celtix");
        res.setId(Integer.valueOf(1));
        return res;
    }

    private void verifyMAPs() {
        if (this.context.getMessageContext() != null) {
            String property = "javax.xml.ws.addressing.context.inbound";
            AddressingProperties maps = (AddressingProperties)this.context.getMessageContext().get((Object)property);
            this.put(WSAddressingTest.verifyMAPs(maps, this));
        }
    }

    public String greetMeSometime(String me) {
        return "greetMeSomeTime:How are you " + me;
    }

    public Future<?> greetMeSometimeAsync(String requestType, AsyncHandler<GreetMeSometimeResponse> asyncHandler) {
        return null;
    }

    public Response<GreetMeSometimeResponse> greetMeSometimeAsync(String requestType) {
        return null;
    }

    public Response<TestDocLitFaultResponse> testDocLitFaultAsync(String faultType) {
        return null;
    }

    public Future<?> testDocLitFaultAsync(String faultType, AsyncHandler ah) {
        return null;
    }

    public Future<?> testDocLitBareAsync(String bare, AsyncHandler ah) {
        return null;
    }

    public Response<BareDocumentResponse> testDocLitBareAsync(String bare) {
        return null;
    }

    public Future<?> greetMeAsync(String requestType, AsyncHandler<GreetMeResponse> asyncHandler) {
        return null;
    }

    public Response<GreetMeResponse> greetMeAsync(String requestType) {
        return null;
    }

    public Future<?> greetMeLaterAsync(long requestType, AsyncHandler<GreetMeLaterResponse> asyncHandler) {
        return null;
    }

    public Response<GreetMeLaterResponse> greetMeLaterAsync(long requestType) {
        return null;
    }

    public Future<?> sayHiAsync(AsyncHandler<SayHiResponse> asyncHandler) {
        return null;
    }

    public Response<SayHiResponse> sayHiAsync() {
        return null;
    }

    public String testNillable(String nillElem, int intElem) {
        return null;
    }

    public Response<TestNillableResponse> testNillableAsync(String nillElem, int intElem) {
        return null;
    }

    public Future<?> testNillableAsync(String nillElem, int intElem, AsyncHandler<TestNillableResponse> asyncHandler) {
        return null;
    }

    protected boolean verify(Logger log) {
        if (this.verified != null) {
            System.out.println("MAP/Header verification failed: " + this.verified);
            log.log(Level.WARNING, "MAP/Header verification failed: {0}", this.verified);
        }
        return this.verified == null;
    }

    @Override
    public void put(String verification) {
        if (verification != null) {
            this.verified = this.verified == null ? verification : this.verified + "; " + verification;
        }
    }
}

