/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.servicemix.camel.nmr.AbstractComponentTest;
import org.apache.servicemix.nmr.api.AbortedException;
import org.junit.Test;

public class TimeoutTest
extends AbstractComponentTest {
    private static final String SLOW_MESSAGE = "Take the slow route, please!";
    private static final String FAST_MESSAGE = "Get me there as quickly as you can!";
    private static final String RESPONSE_MESSAGE = "You've arrived at your destination!";
    private static final Long TIMEOUT = 1000L;

    @Test
    public void testFastInOutWithTimeout() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:timeout");
        mock.expectedMessageCount(1);
        Exchange result = this.template.request("direct:timeout", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)TimeoutTest.FAST_MESSAGE);
            }
        });
        this.assertMockEndpointsSatisfied();
        TimeoutTest.assertFalse((String)"Exchange got finished successfully", (boolean)result.isFailed());
        TimeoutTest.assertEquals((String)"Response message got set", (Object)RESPONSE_MESSAGE, (Object)result.getOut().getBody());
    }

    @Test
    public void testSlowInOutWithTimeout() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:timeout");
        mock.expectedMessageCount(0);
        Exchange result = this.template.request("direct:timeout", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)TimeoutTest.SLOW_MESSAGE);
            }
        });
        TimeoutTest.assertTrue((String)"Exchange got finished successfully", (boolean)result.isFailed());
        TimeoutTest.assertFalse((String)"Response message not set", (boolean)result.hasOut());
        TimeoutTest.assertTrue((String)"TimeoutException was thrown", (boolean)(result.getException() instanceof AbortedException));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:timeout").choice().when((Predicate)this.simple("${body} contains slow")).to("nmr:slow-route?timeout=" + TIMEOUT)).otherwise().to("nmr:fast-route?timeout=" + TIMEOUT)).end().to("mock:timeout");
                this.from("nmr:fast-route").process((Processor)new ResponseProcessor());
                this.from("nmr:slow-route").delay(2L * TIMEOUT).process((Processor)new ResponseProcessor());
            }
        };
    }

    private final class ResponseProcessor
    implements Processor {
        private ResponseProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getOut().setBody((Object)TimeoutTest.RESPONSE_MESSAGE);
        }
    }
}

